/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.io.ArrayPool;
import cn.wjybxx.base.io.ConcurrentArrayPool;
import cn.wjybxx.base.io.SimpleArrayPool;
import java.util.Objects;

public abstract class ArrayPoolBuilder<T> {
    private final Class<T> arrayType;
    private int poolSize = 16;
    private int defCapacity = 4096;
    private int maxCapacity = 65536;
    private boolean clear;

    public ArrayPoolBuilder(Class<T> arrayType) {
        this.arrayType = Objects.requireNonNull(arrayType, "arrayType");
    }

    public abstract ArrayPool<T> build();

    public Class<T> getArrayType() {
        return this.arrayType;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ArrayPoolBuilder<T> setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    public boolean isClear() {
        return this.clear;
    }

    public ArrayPoolBuilder<T> setClear(boolean clear) {
        this.clear = clear;
        return this;
    }

    public int getDefCapacity() {
        return this.defCapacity;
    }

    public ArrayPoolBuilder<T> setDefCapacity(int defCapacity) {
        this.defCapacity = defCapacity;
        return this;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public ArrayPoolBuilder<T> setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        return this;
    }

    public static <T> SimpleArrayPoolBuilder<T> newSimpleBuilder(Class<T> arrayType) {
        return new SimpleArrayPoolBuilder<T>(arrayType);
    }

    public static <T> ConcurrentArrayPoolBuilder<T> newConcurrentBuilder(Class<T> arrayType) {
        return new ConcurrentArrayPoolBuilder<T>(arrayType);
    }

    public static class SimpleArrayPoolBuilder<T>
    extends ArrayPoolBuilder<T> {
        public SimpleArrayPoolBuilder(Class<T> arrayType) {
            super(arrayType);
        }

        @Override
        public SimpleArrayPool<T> build() {
            return new SimpleArrayPool(this);
        }

        @Override
        public SimpleArrayPoolBuilder<T> setDefCapacity(int defCapacity) {
            super.setDefCapacity(defCapacity);
            return this;
        }

        @Override
        public SimpleArrayPoolBuilder<T> setMaxCapacity(int maxCapacity) {
            super.setMaxCapacity(maxCapacity);
            return this;
        }

        @Override
        public SimpleArrayPoolBuilder<T> setClear(boolean clear) {
            super.setClear(clear);
            return this;
        }

        @Override
        public SimpleArrayPoolBuilder<T> setPoolSize(int poolSize) {
            super.setPoolSize(poolSize);
            return this;
        }
    }

    public static class ConcurrentArrayPoolBuilder<T>
    extends ArrayPoolBuilder<T> {
        public ConcurrentArrayPoolBuilder(Class<T> arrayType) {
            super(arrayType);
        }

        @Override
        public ConcurrentArrayPool<T> build() {
            return new ConcurrentArrayPool(this);
        }

        @Override
        public ConcurrentArrayPoolBuilder<T> setDefCapacity(int defCapacity) {
            super.setDefCapacity(defCapacity);
            return this;
        }

        @Override
        public ConcurrentArrayPoolBuilder<T> setMaxCapacity(int maxCapacity) {
            super.setMaxCapacity(maxCapacity);
            return this;
        }

        @Override
        public ConcurrentArrayPoolBuilder<T> setClear(boolean clear) {
            super.setClear(clear);
            return this;
        }

        @Override
        public ConcurrentArrayPoolBuilder<T> setPoolSize(int poolSize) {
            super.setPoolSize(poolSize);
            return this;
        }
    }
}

