/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.EnumLite;
import cn.wjybxx.base.EnumLiteMap;
import cn.wjybxx.base.OptionalBool;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;

public class EnumUtils {
    private EnumUtils() {
    }

    @Nullable
    public static <T extends Enum<T>> T forName(List<T> values, String name) {
        for (Enum t : values) {
            if (!t.name().equals(name)) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends Enum<T>> T forNameIgnoreCase(List<T> values, String name) {
        for (Enum t : values) {
            if (!t.name().equalsIgnoreCase(name)) continue;
            return (T)t;
        }
        return null;
    }

    @SafeVarargs
    public static <T extends Enum<T>> BitSet toBitSet(T ... values) {
        BitSet bitSet = new BitSet(64);
        for (T e : values) {
            bitSet.set(((Enum)e).ordinal());
        }
        return bitSet;
    }

    public static <T extends Enum<T>> BitSet toBitSet(Collection<T> values) {
        BitSet bitSet = new BitSet(64);
        for (Enum e : values) {
            bitSet.set(e.ordinal());
        }
        return bitSet;
    }

    public static <T> void checkNumberDuplicate(List<T> values, ToIntFunction<? super T> func) {
        HashSet<Integer> numberSet = CollectionUtils.newHashSet(values.size());
        for (T t : values) {
            int number = func.applyAsInt(t);
            if (numberSet.add(number)) continue;
            String msg = String.format("The number is duplicate, num: %d, enum: %s", number, t.toString());
            throw new IllegalArgumentException(msg);
        }
    }

    public static <T> void checkNumberContinuity(List<T> values, @Nullable Integer baseNumber, ToIntFunction<? super T> func) {
        int firstNumber;
        if (values.isEmpty()) {
            return;
        }
        if (baseNumber != null && (firstNumber = func.applyAsInt(values.get(0))) != baseNumber) {
            throw new IllegalArgumentException(String.format("baseNumber expected: %d, but found: %d", baseNumber, firstNumber));
        }
        for (int index = 0; index < values.size() - 1; ++index) {
            int nextNumber;
            int curNumber = func.applyAsInt(values.get(index));
            if (curNumber + 1 == (nextNumber = func.applyAsInt(values.get(index + 1)))) continue;
            throw new IllegalArgumentException("the number or values is not continuity, value: " + String.valueOf(values.get(index)));
        }
    }

    public static <T> OptionalBool isNumberContinuity(List<T> values, ToIntFunction<? super T> func) {
        if (values.size() == 0) {
            return OptionalBool.EMPTY;
        }
        if (values.size() == 1) {
            return OptionalBool.TRUE;
        }
        for (int index = 0; index < values.size() - 1; ++index) {
            int nextNumber;
            int curNumber = func.applyAsInt(values.get(index));
            if (curNumber + 1 == (nextNumber = func.applyAsInt(values.get(index + 1)))) continue;
            return OptionalBool.FALSE;
        }
        return OptionalBool.TRUE;
    }

    public static <T extends EnumLite> void checkNumberContinuity(List<T> values, @Nullable Integer baseNumber) {
        EnumUtils.checkNumberContinuity(values, baseNumber, EnumLite::getNumber);
    }

    public static <T extends EnumLite> void checkNumberDuplicate(List<T> values) {
        EnumUtils.checkNumberDuplicate(values, EnumLite::getNumber);
    }

    public static <T extends EnumLite> OptionalBool isNumberContinuity(List<T> values) {
        return EnumUtils.isNumberContinuity(values, EnumLite::getNumber);
    }

    public static <T extends EnumLite> EnumLiteMap<T> mapping(T[] values) {
        return EnumUtils.mapping(values, (boolean)false);
    }

    public static <T extends EnumLite> EnumLiteMap<T> mapping(T[] values, boolean fastQuery) {
        if (values.length == 0) {
            return EmptyMap.INSTANCE;
        }
        if (values.length == 1) {
            return new SingletonMap<T>(values[0]);
        }
        values = (EnumLite[])Arrays.copyOf(values, values.length);
        EnumUtils.checkNumberDuplicate(Arrays.asList(values));
        int minNumber = EnumUtils.minNumber(values);
        int maxNumber = EnumUtils.maxNumber(values);
        if (EnumUtils.isArrayAvailable(minNumber, maxNumber, values.length, fastQuery)) {
            return new DirectArrayMap(values, minNumber, maxNumber);
        }
        return new BinarySearchArrayMap(values);
    }

    private static <T extends EnumLite> int minNumber(T[] values) {
        return Arrays.stream(values).mapToInt(EnumLite::getNumber).min().orElseThrow();
    }

    private static <T extends EnumLite> int maxNumber(T[] values) {
        return Arrays.stream(values).mapToInt(EnumLite::getNumber).max().orElseThrow();
    }

    private static boolean isArrayAvailable(int minNumber, int maxNumber, int length, boolean fastQuery) {
        if (DirectArrayMap.matchDefaultFactor(minNumber, maxNumber, length)) {
            return true;
        }
        return fastQuery && DirectArrayMap.matchMinFactor(minNumber, maxNumber, length);
    }

    private static class EmptyMap<T extends EnumLite>
    implements EnumLiteMap<T> {
        private static final EmptyMap<?> INSTANCE = new EmptyMap();

        private EmptyMap() {
        }

        @Override
        @Nullable
        public T forNumber(int number) {
            return null;
        }

        @Override
        public List<T> values() {
            return Collections.emptyList();
        }

        @Override
        public List<T> sortedValues() {
            return Collections.emptyList();
        }
    }

    private static class SingletonMap<T extends EnumLite>
    implements EnumLiteMap<T> {
        private final List<T> values;

        private SingletonMap(T val) {
            Objects.requireNonNull(val);
            this.values = List.of(val);
        }

        @Override
        public List<T> values() {
            return this.values;
        }

        @Override
        public List<T> sortedValues() {
            return this.values;
        }

        @Override
        @Nullable
        public T forNumber(int number) {
            EnumLite singleton = (EnumLite)this.values.get(0);
            if (number == singleton.getNumber()) {
                return (T)singleton;
            }
            return null;
        }
    }

    private static class DirectArrayMap<T extends EnumLite>
    implements EnumLiteMap<T> {
        private static final float DEFAULT_FACTOR = 0.5f;
        private static final float MIN_FACTOR = 0.25f;
        private final List<T> values;
        private final List<T> sortedValues;
        private final T[] elements;
        private final int minNumber;
        private final int maxNumber;

        private DirectArrayMap(T[] values, int minNumber, int maxNumber) {
            this.values = List.of(values);
            this.minNumber = minNumber;
            this.maxNumber = maxNumber;
            int capacity = DirectArrayMap.capacity(minNumber, maxNumber);
            this.elements = (EnumLite[])Array.newInstance(values.getClass().getComponentType(), capacity);
            for (T e : values) {
                this.elements[this.toIndex((int)e.getNumber())] = e;
            }
            this.sortedValues = capacity == values.length ? List.of(this.elements) : Arrays.stream(this.elements).filter(Objects::nonNull).toList();
        }

        @Override
        @Nullable
        public T forNumber(int number) {
            if (number < this.minNumber || number > this.maxNumber) {
                return null;
            }
            return this.elements[this.toIndex(number)];
        }

        @Override
        public List<T> values() {
            return this.values;
        }

        @Override
        public List<T> sortedValues() {
            return this.sortedValues;
        }

        private int toIndex(int number) {
            return number - this.minNumber;
        }

        private static boolean matchDefaultFactor(int minNumber, int maxNumber, int length) {
            return DirectArrayMap.matchFactor(minNumber, maxNumber, length, 0.5f);
        }

        private static boolean matchMinFactor(int minNumber, int maxNumber, int length) {
            return DirectArrayMap.matchFactor(minNumber, maxNumber, length, 0.25f);
        }

        private static boolean matchFactor(int minNumber, int maxNumber, int length, float factor) {
            return (double)length >= Math.ceil((float)DirectArrayMap.capacity(minNumber, maxNumber) * factor);
        }

        private static int capacity(int minNumber, int maxNumber) {
            return maxNumber - minNumber + 1;
        }
    }

    private static class BinarySearchArrayMap<T extends EnumLite>
    implements EnumLiteMap<T> {
        private final List<T> values;
        private final List<T> sortedValues;

        private BinarySearchArrayMap(T[] values) {
            this.values = List.of(values);
            this.sortedValues = CollectionUtils.toImmutableList(this.values, Comparator.comparingInt(EnumLite::getNumber));
        }

        @Override
        @Nullable
        public T forNumber(int number) {
            List<T> list = this.sortedValues;
            int low = 0;
            int high = list.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                EnumLite midVal = (EnumLite)list.get(mid);
                int cmp = Integer.compare(midVal.getNumber(), number);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return (T)midVal;
            }
            return null;
        }

        @Override
        public List<T> values() {
            return this.values;
        }

        @Override
        public List<T> sortedValues() {
            return this.sortedValues;
        }
    }
}

