/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.Constant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public abstract class AbstractConstant<T extends AbstractConstant<T>>
implements Constant<T> {
    private static final AtomicLong uniqueIdGenerator = new AtomicLong();
    private final int id;
    private final String name;
    private final long uniqueId;

    protected AbstractConstant(Constant.Builder<?> builder) {
        this.id = builder.getIdOrThrow();
        this.name = Objects.requireNonNull(builder.getName());
        this.uniqueId = uniqueIdGenerator.incrementAndGet();
    }

    @Override
    public final int id() {
        return this.id;
    }

    @Override
    public final String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public final int compareTo(@Nonnull T other) {
        if (this == other) {
            return 0;
        }
        T that = other;
        if (this.uniqueId < ((AbstractConstant)that).uniqueId) {
            return -1;
        }
        if (this.uniqueId > ((AbstractConstant)that).uniqueId) {
            return 1;
        }
        throw new Error("failed to compare two different constants, this: " + this.name + ", that: " + ((AbstractConstant)that).name);
    }
}

