/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.io.IORuntimeException;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner {
    private ClassScanner() {
    }

    public static Set<Class<?>> findAllClass(String pkgName) {
        return ClassScanner.findClasses(pkgName, f -> true, f -> true);
    }

    public static Set<Class<?>> findClasses(String pkgName, Predicate<String> classNameFilter, Predicate<Class<?>> classFilter) {
        return ClassScanner.findClasses(pkgName, classNameFilter, classFilter, null);
    }

    public static Set<Class<?>> findClasses(String pkgName, Predicate<String> classNameFilter, Predicate<Class<?>> classFilter, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        LinkedHashSet classes = new LinkedHashSet();
        String pkgPath = pkgName.replace('.', '/');
        try {
            Enumeration<URL> urls = classLoader.getResources(pkgPath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8);
                    ClassScanner.findClassesByFile(classLoader, filePath, classes, pkgName, classNameFilter, classFilter);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                ClassScanner.findClassesByJar(classLoader, jar, classes, pkgName, classNameFilter, classFilter);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException("pkgName: " + pkgName, e);
        }
        return classes;
    }

    private static void findClassesByFile(ClassLoader classLoader, String pkgPath, Set<Class<?>> classOut, String pkgName, Predicate<String> classNameFilter, Predicate<Class<?>> classFilter) {
        File dir = new File(pkgPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(file -> file.isDirectory() || file.getName().endsWith(".class"));
        if (dirFiles == null) {
            return;
        }
        for (File file2 : dirFiles) {
            String fileName = file2.getName();
            if (file2.isDirectory()) {
                if (ClassScanner.isHiddenFolder(fileName)) continue;
                ClassScanner.findClassesByFile(classLoader, pkgPath + "/" + fileName, classOut, pkgName + "." + fileName, classNameFilter, classFilter);
                continue;
            }
            String className = pkgName + "." + fileName.substring(0, fileName.length() - 6);
            if (!classNameFilter.test(className)) continue;
            try {
                Class<?> clazz = classLoader.loadClass(className);
                if (!classFilter.test(clazz)) continue;
                classOut.add(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException("loadClass failed, pkgName: %s, className: %s".formatted(pkgName, className), e);
            }
        }
    }

    private static boolean isHiddenFolder(String folderName) {
        return folderName.charAt(0) == '.';
    }

    private static void findClassesByJar(ClassLoader classLoader, JarFile jar, Set<Class<?>> classOut, String pkgName, Predicate<String> classNameFilter, Predicate<Class<?>> classFilter) {
        String pkgPath = pkgName.replace(".", "/") + "/";
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            String className;
            String filePath;
            JarEntry jarEntry = entry.nextElement();
            if (jarEntry.isDirectory() || !(filePath = jarEntry.getName()).startsWith(pkgPath) || !filePath.endsWith(".class") || !classNameFilter.test(className = filePath.substring(0, filePath.length() - 6).replace("/", "."))) continue;
            try {
                Class<?> clazz = classLoader.loadClass(className);
                if (!classFilter.test(clazz)) continue;
                classOut.add(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException("loadClass failed, pkgName: %s, className: %s".formatted(pkgName, className), e);
            }
        }
    }
}

