/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import java.util.Random;

public class MathCommon {
    public static final int MAX_POWER_OF_TWO = 0x40000000;
    public static final long LONG_MAX_POWER_OF_TWO = 0x4000000000000000L;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-5f;
    public static final float DOUBLE_ROUNDING_ERROR = 1.0E-9f;
    public static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    public static final long UINT48_MAX_VALUE = 0xFFFFFFFFFFFFL;
    public static final long INT48_MAX_VALUE = 0x7FFFFFFFFFFFL;
    public static final long INT48_MIN_VALUE = -140737488355328L;
    public static final int INT_MASK4 = -16777216;
    public static final int INT_MASK3 = 0xFF0000;
    public static final int INT_MASK2 = 65280;
    public static final int INT_MASK1 = 255;
    public static final long LONG_MASK8 = -72057594037927936L;
    public static final long LONG_MASK7 = 0xFF000000000000L;
    public static final long LONG_MASK6 = 0xFF0000000000L;
    public static final long LONG_MASK5 = 0xFF00000000L;
    public static final long LONG_MASK4 = 0xFF000000L;
    public static final long LONG_MASK3 = 0xFF0000L;
    public static final long LONG_MASK2 = 65280L;
    public static final long LONG_MASK1 = 255L;
    public static final Random SHARED_RANDOM = new Random();

    protected MathCommon() {
    }

    public static boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static int nextPowerOfTwo(int num) {
        if (num < 1) {
            return 1;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(num - 1);
    }

    public static long nextPowerOfTwo(long num) {
        if (num < 1L) {
            return 1L;
        }
        return 1L << 64 - Long.numberOfLeadingZeros(num - 1L);
    }

    public static boolean isEven(int x) {
        return (x & 1) == 0;
    }

    public static boolean isOdd(int x) {
        return (x & 1) == 1;
    }

    public static boolean isUInt32(long value) {
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    public static boolean isUInt48(long value) {
        return value >= 0L && value <= 0xFFFFFFFFFFFFL;
    }

    public static boolean isInt48(long value) {
        return value >= -140737488355328L && value <= 0x7FFFFFFFFFFFL;
    }

    public static long composeIntToLong(int higher, int lower) {
        return (long)higher << 32 | (long)lower & 0xFFFFFFFFL;
    }

    public static int higherIntOfLong(long value) {
        return (int)(value >>> 32);
    }

    public static int lowerIntOfLong(long value) {
        return (int)value;
    }

    public static int composeShortToInt(short higher, short lower) {
        return higher << 16 | lower & 0xFFFF;
    }

    public static short higherShortOfInt(int value) {
        return (short)(value >>> 16);
    }

    public static short lowerShortOfInt(int value) {
        return (short)value;
    }

    public static long multiplyToLong(int a, int b) {
        return (long)a * (long)b;
    }

    public static int multiplyToInt(short a, short b) {
        return a * b;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp01(float value) {
        if (value <= 0.0f) {
            return 0.0f;
        }
        if (value >= 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public static double clamp01(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= 1.0) {
            return 1.0;
        }
        return value;
    }

    public static int min(int a, int b, int c) {
        if (a > b) {
            a = b;
        }
        if (a > c) {
            a = c;
        }
        return a;
    }

    public static int max(int a, int b, int c) {
        if (a < b) {
            a = b;
        }
        if (a < c) {
            a = c;
        }
        return a;
    }

    public static long min(long a, long b, long c) {
        if (a > b) {
            a = b;
        }
        if (a > c) {
            a = c;
        }
        return a;
    }

    public static long max(long a, long b, long c) {
        if (a < b) {
            a = b;
        }
        if (a < c) {
            a = c;
        }
        return a;
    }

    public static float min(float a, float b, float c) {
        float r = Math.min(a, b);
        return Math.min(r, c);
    }

    public static float max(float a, float b, float c) {
        float r = Math.max(a, b);
        return Math.max(r, c);
    }

    public static double min(double a, double b, double c) {
        double r = Math.min(a, b);
        return Math.min(r, c);
    }

    public static double max(double a, double b, double c) {
        double r = Math.max(a, b);
        return Math.max(r, c);
    }

    public static int min(short a, short b) {
        return a < b ? a : b;
    }

    public static int max(short a, short b) {
        return a > b ? a : b;
    }

    public static int min(short a, short b, short c) {
        if (a > b) {
            a = b;
        }
        if (a > c) {
            a = c;
        }
        return a;
    }

    public static int max(short a, short b, short c) {
        if (a < b) {
            a = b;
        }
        if (a < c) {
            a = c;
        }
        return a;
    }

    public static boolean isBetween(short value, short min, short max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(long value, long min, long max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(float value, float min, float max) {
        return value >= min && value <= max;
    }

    public static boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isZero(float value) {
        return Math.abs(value) <= 1.0E-5f;
    }

    public static boolean isZero(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-5f;
    }

    public static boolean isEqual(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static boolean isZero(double value) {
        return Math.abs(value) <= (double)1.0E-9f;
    }

    public static boolean isZero(double value, double tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) <= (double)1.0E-9f;
    }

    public static boolean isEqual(double a, double b, double tolerance) {
        return Math.abs(a - b) <= tolerance;
    }
}

