/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;

public class ThreadUtils {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(Set.of(StackWalker.Option.SHOW_HIDDEN_FRAMES, StackWalker.Option.SHOW_REFLECT_FRAMES, StackWalker.Option.RETAIN_CLASS_REFERENCE));

    public static void clearInterrupted() {
        Thread.interrupted();
    }

    public static void recoveryInterrupted() {
        try {
            Thread.currentThread().interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void recoveryInterrupted(Throwable t) {
        if (t instanceof InterruptedException) {
            try {
                Thread.currentThread().interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static void sleepQuietly(long sleepMillis) {
        LockSupport.parkNanos(1L);
        LockSupport.parkNanos(sleepMillis * 1000000L);
    }

    public static void joinUninterruptedly(Thread thread) {
        boolean interrupted = false;
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            ThreadUtils.recoveryInterrupted();
        }
    }

    public static String getCallerInfo(int deep) {
        return STACK_WALKER.walk(stackFrameStream -> stackFrameStream.limit(deep + 1).reduce((stackFrame, stackFrame2) -> stackFrame2).map(Object::toString)).orElse("Unknown source");
    }

    public static String getCallerInfo(Predicate<StackWalker.StackFrame> filter) {
        return STACK_WALKER.walk(stackFrameStream -> stackFrameStream.filter(stackFrame -> stackFrame.getDeclaringClass() != ThreadUtils.class).filter(filter).findFirst().map(Object::toString)).orElse("Unknown source");
    }
}

