/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.SystemPropsUtils;
import cn.wjybxx.base.io.ArrayPool;
import cn.wjybxx.base.io.SimpleArrayPool;

public class LocalByteArrayPool
implements ArrayPool<byte[]> {
    public static final LocalByteArrayPool INSTANCE = new LocalByteArrayPool();
    private static final int POOL_SIZE = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalByteArrayPool.PoolSize", 4);
    private static final int INIT_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalByteArrayPool.InitCapacity", 4096);
    private static final int MAX_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalByteArrayPool.MaxCapacity", 0x100000);
    private static final ThreadLocal<SimpleArrayPool<byte[]>> THREAD_LOCAL_INST = ThreadLocal.withInitial(() -> new SimpleArrayPool<byte[]>(byte[].class, POOL_SIZE, INIT_CAPACITY, MAX_CAPACITY));

    @Override
    public byte[] rent() {
        return THREAD_LOCAL_INST.get().rent();
    }

    @Override
    public byte[] rent(int minimumLength) {
        return THREAD_LOCAL_INST.get().rent(minimumLength);
    }

    @Override
    public byte[] rent(int minimumLength, boolean clear) {
        return THREAD_LOCAL_INST.get().rent(minimumLength, clear);
    }

    @Override
    public void returnOne(byte[] array) {
        THREAD_LOCAL_INST.get().returnOne(array);
    }

    @Override
    public void returnOne(byte[] array, boolean clear) {
        THREAD_LOCAL_INST.get().returnOne(array, clear);
    }

    @Override
    public void freeAll() {
    }

    public SimpleArrayPool<byte[]> localInst() {
        return THREAD_LOCAL_INST.get();
    }
}

