/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.reflect;

import cn.wjybxx.base.reflect.TypeParameterFinder;
import javax.annotation.Nonnull;

public abstract class TypeParameterMatcher {
    public abstract boolean matchInstance(@Nonnull Object var1);

    public abstract boolean matchType(Class<?> var1);

    public static <T> TypeParameterMatcher findTypeMatcher(@Nonnull T instance, @Nonnull Class<? super T> superClazzOrInterface, @Nonnull String typeParamName) {
        Class<?> type = TypeParameterFinder.findTypeParameter(instance, superClazzOrInterface, typeParamName);
        if (type == Object.class) {
            return ObjectTypeMatcher.INSTANCE;
        }
        return new ReflectiveTypeMatcher(type);
    }

    private static class ObjectTypeMatcher
    extends TypeParameterMatcher {
        private static final ObjectTypeMatcher INSTANCE = new ObjectTypeMatcher();

        private ObjectTypeMatcher() {
        }

        @Override
        public boolean matchInstance(@Nonnull Object instance) {
            return true;
        }

        @Override
        public boolean matchType(Class<?> type) {
            return true;
        }
    }

    private static class ReflectiveTypeMatcher
    extends TypeParameterMatcher {
        private final Class<?> type;

        private ReflectiveTypeMatcher(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean matchInstance(@Nonnull Object instance) {
            return this.type.isInstance(instance);
        }

        @Override
        public boolean matchType(Class<?> type) {
            return this.type.isAssignableFrom(type);
        }
    }
}

