/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.ObjectUtils;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public class Preconditions {
    public static void checkArgument(boolean b) {
        if (!b) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean b, @Nullable Object message) {
        if (!b) {
            throw new IllegalArgumentException(ObjectUtils.toStringIfNotNull(message));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @Nullable Object message) {
        if (!expression) {
            throw new IllegalStateException(ObjectUtils.toStringIfNotNull(message));
        }
    }

    public static <T> T checkNotNull(T v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return v;
    }

    public static <T> T checkNotNull(T v, @Nullable Object message) {
        if (v == null) {
            throw new NullPointerException(ObjectUtils.toStringIfNotNull(message));
        }
        return v;
    }

    public static int checkPositive(int v) {
        if (v <= 0) {
            throw new IllegalArgumentException(Preconditions.checkPositiveMsg(v, null));
        }
        return v;
    }

    public static int checkPositive(int v, String desc) {
        if (v <= 0) {
            throw new IllegalArgumentException(Preconditions.checkPositiveMsg(v, desc));
        }
        return v;
    }

    public static long checkPositive(long v) {
        if (v <= 0L) {
            throw new IllegalArgumentException(Preconditions.checkPositiveMsg(v, null));
        }
        return v;
    }

    public static long checkPositive(long v, String desc) {
        if (v <= 0L) {
            throw new IllegalArgumentException(Preconditions.checkPositiveMsg(v, desc));
        }
        return v;
    }

    private static String checkPositiveMsg(long v, String desc) {
        if (desc == null) {
            return String.format("value expected positive, but found: %d", v);
        }
        return String.format("%s expected positive, but found: %d", desc, v);
    }

    public static int checkNonNegative(int v) {
        if (v < 0) {
            throw new IllegalArgumentException(Preconditions.checkNonNegativeMsg(v, null));
        }
        return v;
    }

    public static int checkNonNegative(int v, String desc) {
        if (v < 0) {
            throw new IllegalArgumentException(Preconditions.checkNonNegativeMsg(v, desc));
        }
        return v;
    }

    public static long checkNonNegative(long v) {
        if (v < 0L) {
            throw new IllegalArgumentException(Preconditions.checkNonNegativeMsg(v, null));
        }
        return v;
    }

    public static long checkNonNegative(long v, String desc) {
        if (v < 0L) {
            throw new IllegalArgumentException(Preconditions.checkNonNegativeMsg(v, desc));
        }
        return v;
    }

    private static String checkNonNegativeMsg(long v, String desc) {
        if (desc == null) {
            return String.format("value expected nonnegative, but found: %d", v);
        }
        return String.format("%s expected nonnegative, but found: %d", desc, v);
    }

    public static int checkBetween(int v, int min, int max) {
        if (v < min || v > max) {
            throw new IllegalArgumentException(Preconditions.checkBetweenMsg(v, min, max, null));
        }
        return v;
    }

    public static int checkBetween(int v, int min, int max, String desc) {
        if (v < min || v > max) {
            throw new IllegalArgumentException(Preconditions.checkBetweenMsg(v, min, max, desc));
        }
        return v;
    }

    public static long checkBetween(long v, long min, long max) {
        if (v < min || v > max) {
            throw new IllegalArgumentException(Preconditions.checkBetweenMsg(v, min, max, null));
        }
        return v;
    }

    public static long checkBetween(long v, long min, long max, String desc) {
        if (v < min || v > max) {
            throw new IllegalArgumentException(Preconditions.checkBetweenMsg(v, min, max, desc));
        }
        return v;
    }

    private static String checkBetweenMsg(long v, long min, long max, String desc) {
        if (desc == null) {
            return String.format("value expected between range[%d, %d], but found: %d", min, max, v);
        }
        return String.format("%s expected between range[%d, %d], but found: %d", desc, min, max, v);
    }

    public static String checkNotEmpty(String value) {
        return Preconditions.checkNotEmpty(value, null);
    }

    public static String checkNotEmpty(String value, @Nullable String desc) {
        if (ObjectUtils.isEmpty(value)) {
            Preconditions.throwArgumentException("value cant be empty", "%s cant be empty", desc);
        }
        return value;
    }

    public static String checkNotBlank(String value) {
        return Preconditions.checkNotBlank(value, null);
    }

    public static String checkNotBlank(String value, @Nullable String desc) {
        if (ObjectUtils.isBlank(value)) {
            Preconditions.throwArgumentException("value cant be blank", "%s cant be blank", desc);
        }
        return value;
    }

    public static String checkNoneWhiteSpace(String value) {
        return Preconditions.checkNoneWhiteSpace(value, null);
    }

    public static String checkNoneWhiteSpace(String value, @Nullable String desc) {
        if (ObjectUtils.containsWhitespace(value)) {
            Preconditions.throwArgumentException("value cant contains whitespace", "%s cant contains whitespace", desc);
        }
        return value;
    }

    public static void checkNotEmpty(Collection<?> collection) {
        Preconditions.checkNotEmpty(collection, null);
    }

    public static void checkNotEmpty(Collection<?> collection, @Nullable String desc) {
        if (collection == null || collection.isEmpty()) {
            Preconditions.throwArgumentException("collection cant be empty", "%s cant be empty", desc);
        }
    }

    public static void checkNotEmpty(Object[] array) {
        Preconditions.checkNotEmpty(array, null);
    }

    public static void checkNotEmpty(Object[] array, @Nullable String desc) {
        if (array == null || array.length == 0) {
            Preconditions.throwArgumentException("array cant be empty", "%s cant be empty", desc);
        }
    }

    public static void checkNullElements(Collection<?> c) {
        Preconditions.checkNullElements(c, null);
    }

    public static void checkNullElements(Collection<?> c, @Nullable String desc) {
        if (c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != null) continue;
                Preconditions.throwArgumentException("collection contains null elements", "%s contains null elements", desc);
            }
        } else {
            for (Object element : c) {
                if (element != null) continue;
                Preconditions.throwArgumentException("collection contains null elements", "%s contains null elements", desc);
            }
        }
    }

    public static void checkNullElements(Object[] array) {
        Preconditions.checkNullElements(array, null);
    }

    public static void checkNullElements(Object[] array, String desc) {
        for (Object element : array) {
            if (element != null) continue;
            Preconditions.throwArgumentException("array contains null elements", "%s contains null elements", desc);
        }
    }

    private static void throwArgumentException(String defaultMsg, String formatMsg, String desc) {
        if (desc == null) {
            throw new IllegalArgumentException(defaultMsg);
        }
        throw new IllegalArgumentException(formatMsg.formatted(desc));
    }

    public static int checkElementIndex(int index, int size) {
        return Preconditions.checkElementIndex(index, size, "index");
    }

    public static int checkElementIndex(int index, int size, String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index, size, desc));
        }
        return index;
    }

    private static String badElementIndex(int index, int size, String desc) {
        if (desc == null) {
            desc = "value";
        }
        if (index < 0) {
            return String.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return String.format("%s (%s) must be less than size (%s)", desc, index, size);
    }
}

