/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.mutable;

import cn.wjybxx.base.mutable.MutableNumber;

public class MutableFloat
extends Number
implements MutableNumber<Float>,
Comparable<MutableFloat> {
    private float value;

    public MutableFloat() {
    }

    public MutableFloat(float value) {
        this.value = value;
    }

    public MutableFloat(Number value) {
        this.value = value.floatValue();
    }

    public MutableFloat(String value) {
        this.value = Float.parseFloat(value);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public void setValue(Float value) {
        this.value = value.floatValue();
    }

    @Override
    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public void add(float operand) {
        this.value += operand;
    }

    public float addAndGet(float operand) {
        this.value += operand;
        return this.value;
    }

    public float getAndAdd(float operand) {
        float last = this.value;
        this.value += operand;
        return last;
    }

    public void increment() {
        this.value += 1.0f;
    }

    public float incrementAndGet() {
        return this.value += 1.0f;
    }

    public float getAndIncrement() {
        float f = this.value;
        this.value = f + 1.0f;
        return f;
    }

    public void decrement() {
        this.value -= 1.0f;
    }

    public float decrementAndGet() {
        return this.value -= 1.0f;
    }

    public float getAndDecrement() {
        float f = this.value;
        this.value = f - 1.0f;
        return f;
    }

    public MutableFloat add(Number operand) {
        this.value += operand.floatValue();
        return this;
    }

    public MutableFloat subtract(Number operand) {
        this.value -= operand.floatValue();
        return this;
    }

    public MutableFloat multiply(Number operand) {
        this.value *= operand.floatValue();
        return this;
    }

    public MutableFloat divide(Number operand) {
        this.value /= operand.floatValue();
        return this;
    }

    @Override
    public int compareTo(MutableFloat that) {
        return Float.compare(this.value, that.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableFloat that = (MutableFloat)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public String toString() {
        return "MutableFloat{value=" + this.value + "}";
    }
}

