/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.collection.IndexedElement;
import java.util.Comparator;
import java.util.Objects;

public final class RefIndexedElement<E>
implements IndexedElement {
    private final E e;
    private Object queue;
    private int index = -1;

    private RefIndexedElement(E e) {
        this.e = Objects.requireNonNull(e);
    }

    public static <E> RefIndexedElement<E> of(E e) {
        return new RefIndexedElement<E>(e);
    }

    public E get() {
        return this.e;
    }

    @Override
    public int collectionIndex(Object collection) {
        return this.queue == collection ? this.index : -1;
    }

    @Override
    public void collectionIndex(Object collection, int index) {
        if (index >= 0) {
            assert (this.queue == collection || this.queue == null);
            this.queue = collection;
            this.index = index;
        } else {
            this.queue = null;
            this.index = -1;
        }
    }

    public static <E> Comparator<RefIndexedElement<E>> wrapComparator(Comparator<? super E> comparator) {
        return new ComparatorAdapter<E>(Objects.requireNonNull(comparator));
    }

    private static class ComparatorAdapter<E>
    implements Comparator<RefIndexedElement<E>> {
        private final Comparator<? super E> adaptee;

        private ComparatorAdapter(Comparator<? super E> adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public int compare(RefIndexedElement<E> o1, RefIndexedElement<E> o2) {
            return this.adaptee.compare(o1.get(), o2.get());
        }
    }
}

