/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.io.ArrayPool;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SimpleArrayPool<T>
implements ArrayPool<T> {
    private static final int DEFAULT_MAX_CAPACITY = 0x100000;
    private final Class<T> arrayType;
    private final int poolSize;
    private final int initCapacity;
    private final int maxCapacity;
    private final boolean clear;
    private final TreeSet<Node<T>> freeArrays;
    private final Consumer<T> clearHandler;
    private static final Comparator<Node<?>> COMPARATOR = Comparator.comparingInt(Node::length);
    private static final Consumer<Object> clear_objectArray = array -> Arrays.fill((Object[])array, null);
    private static final Consumer<Object> clear_byteArray = array -> Arrays.fill((byte[])array, (byte)0);
    private static final Consumer<Object> clear_charArray = array -> Arrays.fill((char[])array, '\u0000');
    private static final Consumer<Object> clear_intArray = array -> Arrays.fill((int[])array, 0);
    private static final Consumer<Object> clear_longArray = array -> Arrays.fill((long[])array, 0L);
    private static final Consumer<Object> clear_floatArray = array -> Arrays.fill((float[])array, 0.0f);
    private static final Consumer<Object> clear_doubleArray = array -> Arrays.fill((double[])array, 0.0);
    private static final Consumer<Object> clear_shortArray = array -> Arrays.fill((short[])array, (short)0);
    private static final Consumer<Object> clear_boolArray = array -> Arrays.fill((boolean[])array, false);

    public SimpleArrayPool(Class<T> arrayType, int poolSize, int initCapacity) {
        this(arrayType, poolSize, initCapacity, 0x100000, false);
    }

    public SimpleArrayPool(Class<T> arrayType, int poolSize, int initCapacity, int maxCapacity) {
        this(arrayType, poolSize, initCapacity, maxCapacity, false);
    }

    public SimpleArrayPool(Class<T> arrayType, int poolSize, int initCapacity, int maxCapacity, boolean clear) {
        if (arrayType.getComponentType() == null) {
            throw new IllegalArgumentException("arrayType");
        }
        if (poolSize < 0 || initCapacity < 0 || maxCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.arrayType = arrayType;
        this.poolSize = poolSize;
        this.initCapacity = initCapacity;
        this.maxCapacity = maxCapacity;
        this.clear = clear;
        this.clearHandler = SimpleArrayPool.findClearHandler(arrayType);
        this.freeArrays = new TreeSet(COMPARATOR);
    }

    @Override
    @Nonnull
    public T rent() {
        Node<T> minNode = this.freeArrays.pollFirst();
        if (minNode != null) {
            return minNode.array();
        }
        return (T)Array.newInstance(this.arrayType.getComponentType(), this.initCapacity);
    }

    @Override
    public T rent(int minimumLength) {
        return this.rent(minimumLength, false);
    }

    @Override
    public T rent(int minimumLength, boolean clear) {
        Node ceilingNode = this.freeArrays.ceiling(new LengthNode(minimumLength));
        if (ceilingNode != null) {
            Object array = ceilingNode.array();
            if (!this.clear && clear) {
                this.clearHandler.accept(array);
            }
            return array;
        }
        return (T)Array.newInstance(this.arrayType.getComponentType(), minimumLength);
    }

    @Override
    public void returnOne(T array) {
        this.returnOneImpl(array, this.clear);
    }

    @Override
    public void returnOne(T array, boolean clear) {
        this.returnOneImpl(array, this.clear || clear);
    }

    private void returnOneImpl(T array, boolean clear) {
        int length = Array.getLength(array);
        if (this.freeArrays.size() < this.poolSize && length <= this.maxCapacity) {
            if (clear) {
                this.clearHandler.accept(array);
            }
            this.freeArrays.add(new ArrayNode<T>(array, length));
        }
    }

    @Override
    public void freeAll() {
        this.freeArrays.clear();
    }

    public static boolean isRefArray(Class<?> arrayType) {
        return !arrayType.getComponentType().isPrimitive();
    }

    public static <T> Consumer<T> findClearHandler(Class<T> arrayType) {
        Class<?> componentType = arrayType.getComponentType();
        if (!componentType.isPrimitive()) {
            return clear_objectArray;
        }
        if (componentType == Byte.TYPE) {
            return clear_byteArray;
        }
        if (componentType == Character.TYPE) {
            return clear_charArray;
        }
        if (componentType == Integer.TYPE) {
            return clear_intArray;
        }
        if (componentType == Long.TYPE) {
            return clear_longArray;
        }
        if (componentType == Float.TYPE) {
            return clear_floatArray;
        }
        if (componentType == Double.TYPE) {
            return clear_doubleArray;
        }
        if (componentType == Short.TYPE) {
            return clear_shortArray;
        }
        if (componentType == Boolean.TYPE) {
            return clear_boolArray;
        }
        throw new IllegalArgumentException("Unsupported arrayType: " + arrayType.getSimpleName());
    }

    private static interface Node<T> {
        public T array();

        public int length();
    }

    private static class LengthNode<T>
    implements Node<T> {
        final int length;

        public LengthNode(int length) {
            this.length = length;
        }

        @Override
        public T array() {
            throw new IllegalStateException();
        }

        @Override
        public int length() {
            return this.length;
        }
    }

    private static class ArrayNode<T>
    implements Node<T> {
        final T array;
        final int length;

        private ArrayNode(T array, int length) {
            this.array = array;
            this.length = length;
        }

        @Override
        public T array() {
            return this.array;
        }

        @Override
        public int length() {
            return this.length;
        }
    }
}

