/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.pool.ObjectPool;
import cn.wjybxx.base.pool.ResetPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DefaultObjectPool<T>
implements ObjectPool<T> {
    private static final int DEFAULT_MAX_CAPACITY = 1024;
    private final ArrayList<T> freeObjects;
    private final int maxCapacity;
    private final Supplier<? extends T> factory;
    private final ResetPolicy<? super T> resetPolicy;

    public DefaultObjectPool(Supplier<? extends T> factory, ResetPolicy<? super T> resetPolicy) {
        this(factory, resetPolicy, 16, 1024);
    }

    public DefaultObjectPool(Supplier<? extends T> factory, ResetPolicy<? super T> resetPolicy, int initialCapacity) {
        this(factory, resetPolicy, initialCapacity, Math.max(1024, initialCapacity));
    }

    public DefaultObjectPool(Supplier<? extends T> factory, ResetPolicy<? super T> resetPolicy, int initialCapacity, int maxCapacity) {
        if (initialCapacity < 0 || initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + ", maxCapacity: " + maxCapacity);
        }
        this.freeObjects = new ArrayList(initialCapacity);
        this.maxCapacity = maxCapacity;
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetPolicy = Objects.requireNonNull(resetPolicy, "resetPolicy");
    }

    @Override
    public T get() {
        ArrayList<T> freeObjects = this.freeObjects;
        return freeObjects.size() == 0 ? this.factory.get() : freeObjects.remove(freeObjects.size() - 1);
    }

    @Override
    public void returnOne(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.resetPolicy.reset(object);
        if (this.freeObjects.size() < this.maxCapacity) {
            this.freeObjects.add(object);
        }
    }

    @Override
    public void returnAll(Collection<? extends T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        ArrayList<T> freeObjects = this.freeObjects;
        int maxCapacity = this.maxCapacity;
        ResetPolicy<T> resetPolicy = this.resetPolicy;
        if (objects instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)objects;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                if (null == e) continue;
                resetPolicy.reset(e);
                if (freeObjects.size() >= maxCapacity) continue;
                freeObjects.add(e);
            }
        } else {
            for (T e : objects) {
                if (null == e) continue;
                resetPolicy.reset(e);
                if (freeObjects.size() >= maxCapacity) continue;
                freeObjects.add(e);
            }
        }
    }

    @Override
    public int maxCount() {
        return this.maxCapacity;
    }

    @Override
    public int idleCount() {
        return this.freeObjects.size();
    }

    @Override
    public void clear() {
        this.freeObjects.clear();
    }
}

