/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.pool.ObjectPool;
import cn.wjybxx.base.pool.ResetPolicy;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SingleObjectPool<T>
implements ObjectPool<T> {
    private final Supplier<? extends T> factory;
    private final ResetPolicy<? super T> resetPolicy;
    private T value;

    public SingleObjectPool(Supplier<? extends T> factory, ResetPolicy<? super T> resetPolicy) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetPolicy = Objects.requireNonNull(resetPolicy, "resetPolicy");
    }

    @Override
    public T get() {
        T result = this.value;
        if (result != null) {
            this.value = null;
        } else {
            result = this.factory.get();
        }
        return result;
    }

    @Override
    public void returnOne(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        assert (object != this.value);
        this.resetPolicy.reset(object);
        this.value = object;
    }

    @Override
    public void returnAll(Collection<? extends T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        for (T v : objects) {
            if (null == v) continue;
            assert (v != this.value);
            this.resetPolicy.reset(v);
            this.value = v;
        }
    }

    @Override
    public int maxCount() {
        return 1;
    }

    @Override
    public int idleCount() {
        return this.value == null ? 0 : 1;
    }

    @Override
    public void clear() {
        this.value = null;
    }
}

