/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;

public class TypeParameterFinder {
    public static <T> Class<?> findTypeParameter(T instance, Class<? super T> superClazzOrInterface, String typeParamName) {
        Objects.requireNonNull(instance, "instance");
        Class<?> thisClass = instance.getClass();
        return TypeParameterFinder.findTypeParameterUnsafe(thisClass, superClazzOrInterface, typeParamName);
    }

    public static <T> Class<?> findTypeParameterUnsafe(Class<T> thisClass, Class<? super T> superClazzOrInterface, String typeParamName) {
        Objects.requireNonNull(thisClass, "thisClass");
        Objects.requireNonNull(superClazzOrInterface, "superClazzOrInterface");
        Objects.requireNonNull(typeParamName, "typeParamName");
        if (thisClass == superClazzOrInterface) {
            throw new IllegalArgumentException("typeParam " + typeParamName + " is declared in self class: " + thisClass.getSimpleName() + ", only support find superClassOrInterface typeParam.");
        }
        TypeParameterFinder.ensureTypeParameterExist(superClazzOrInterface, typeParamName);
        if (superClazzOrInterface.isInterface()) {
            return TypeParameterFinder.findInterfaceTypeParameter(thisClass, superClazzOrInterface, typeParamName);
        }
        return TypeParameterFinder.find0(thisClass, superClazzOrInterface, typeParamName);
    }

    private static void ensureTypeParameterExist(Class<?> parametrizedSuperInterface, String typeParamName) {
        TypeVariable<Class<?>>[] typeParameters;
        for (TypeVariable<Class<?>> typeVariable : typeParameters = parametrizedSuperInterface.getTypeParameters()) {
            if (!typeVariable.getName().equals(typeParamName)) continue;
            return;
        }
        throw new IllegalArgumentException("typeParamName " + typeParamName + " is not declared in superClazz/interface " + parametrizedSuperInterface.getSimpleName());
    }

    private static <T> Class<?> findInterfaceTypeParameter(Class<T> thisClass, Class<? super T> parametrizedSuperInterface, String typeParamName) {
        Class<? super T> directChildClass = TypeParameterFinder.findInterfaceDirectChildClass(thisClass, parametrizedSuperInterface);
        return TypeParameterFinder.parseTypeParameter(thisClass, directChildClass, parametrizedSuperInterface, typeParamName);
    }

    private static <T> Class<? super T> findInterfaceDirectChildClass(Class<? super T> currentClazzOrInterface, Class<? super T> parametrizedSuperInterface) {
        Class<?>[] implementationInterfaces;
        if (!parametrizedSuperInterface.isAssignableFrom(currentClazzOrInterface)) {
            throw new IllegalArgumentException("currentClazzOrInterface=" + currentClazzOrInterface.getSimpleName() + " ,parametrizedSuperInterface=" + parametrizedSuperInterface.getSimpleName());
        }
        for (Class<?> clazz : implementationInterfaces = currentClazzOrInterface.getInterfaces()) {
            if (clazz != parametrizedSuperInterface) continue;
            return currentClazzOrInterface;
        }
        Class<? super T> superclass = currentClazzOrInterface.getSuperclass();
        if (null != superclass && parametrizedSuperInterface.isAssignableFrom(superclass)) {
            return TypeParameterFinder.findInterfaceDirectChildClass(superclass, parametrizedSuperInterface);
        }
        assert (parametrizedSuperInterface.isInterface()) : "currentClazzOrInterface " + currentClazzOrInterface.getSimpleName() + " i";
        for (Class<?> oneSuperInterface : implementationInterfaces) {
            if (!parametrizedSuperInterface.isAssignableFrom(oneSuperInterface)) continue;
            Class<?> superInterface = oneSuperInterface;
            return TypeParameterFinder.findInterfaceDirectChildClass(superInterface, parametrizedSuperInterface);
        }
        throw new RuntimeException();
    }

    private static <T> Class<?> parseTypeParameter(Class<? extends T> thisClass, Class<? super T> directChildClass, Class<? super T> parametrizedSuperInterface, String typeParamName) {
        int typeParamIndex = -1;
        TypeVariable<Class<? super T>>[] typeParams = parametrizedSuperInterface.getTypeParameters();
        for (int i = 0; i < typeParams.length; ++i) {
            if (!typeParamName.equals(typeParams[i].getName())) continue;
            typeParamIndex = i;
            break;
        }
        assert (typeParamIndex >= 0);
        Type genericSuperInterface = null;
        Class<?>[] extendsOrImpInterfaces = directChildClass.getInterfaces();
        for (int index = 0; index < extendsOrImpInterfaces.length; ++index) {
            if (extendsOrImpInterfaces[index] != parametrizedSuperInterface) continue;
            genericSuperInterface = directChildClass.getGenericInterfaces()[index];
            break;
        }
        assert (null != genericSuperInterface) : "genericSuperInterface";
        if (!(genericSuperInterface instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] actualTypeParams = ((ParameterizedType)genericSuperInterface).getActualTypeArguments();
        Type actualTypeParam = actualTypeParams[typeParamIndex];
        if (actualTypeParam instanceof ParameterizedType) {
            actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
        }
        if (actualTypeParam instanceof Class) {
            return (Class)actualTypeParam;
        }
        if (actualTypeParam instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
            if (componentType instanceof ParameterizedType) {
                componentType = ((ParameterizedType)componentType).getRawType();
            }
            if (componentType instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
        }
        if (actualTypeParam instanceof TypeVariable) {
            TypeVariable v = (TypeVariable)actualTypeParam;
            if (!(v.getGenericDeclaration() instanceof Class)) {
                return Object.class;
            }
            Class genericDeclarationClass = (Class)v.getGenericDeclaration();
            if (parametrizedSuperInterface.isAssignableFrom(thisClass)) {
                Class newSuperClazzOrInerface = genericDeclarationClass;
                return TypeParameterFinder.findTypeParameterUnsafe(thisClass, newSuperClazzOrInerface, v.getName());
            }
            return Object.class;
        }
        return TypeParameterFinder.fail(thisClass, typeParamName);
    }

    private static Class<?> fail(Class<?> type, String typeParamName) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + typeParamName + "': " + String.valueOf(type));
    }

    private static Class<?> find0(Class<?> thisClass, Class<?> parametrizedSuperclass, String typeParamName) {
        Class<?> currentClass = thisClass;
        while (true) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = -1;
                TypeVariable<Class<?>>[] typeParams = currentClass.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParamName.equals(typeParams[i].getName())) continue;
                    typeParamIndex = i;
                    break;
                }
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + String.valueOf(parametrizedSuperclass));
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    return (Class)actualTypeParam;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    TypeVariable v = (TypeVariable)actualTypeParam;
                    currentClass = thisClass;
                    if (!(v.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    parametrizedSuperclass = (Class)v.getGenericDeclaration();
                    typeParamName = v.getName();
                    if (parametrizedSuperclass.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                return TypeParameterFinder.fail(thisClass, typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        return TypeParameterFinder.fail(thisClass, typeParamName);
    }
}

