/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.time;

import cn.wjybxx.base.time.CachedTimeProvider;
import cn.wjybxx.base.time.TimeProvider;
import cn.wjybxx.base.time.Timepiece;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

public class TimeProviders {
    private TimeProviders() {
    }

    public static TimeProvider systemMillisProvider() {
        return SystemTimeProvider.INSTANCE;
    }

    public static TimeProvider systemNanosProvider() {
        return SystemNanoTimeProvider.INSTANCE;
    }

    public static CachedTimeProvider newTimeProvider(long curTime) {
        return new UnsharableCachedTimeProvider(curTime);
    }

    public static Timepiece newTimepiece() {
        return new UnsharableTimepiece();
    }

    @ThreadSafe
    private static class SystemTimeProvider
    implements TimeProvider {
        static final SystemTimeProvider INSTANCE = new SystemTimeProvider();

        private SystemTimeProvider() {
        }

        @Override
        public long getTime() {
            return System.currentTimeMillis();
        }

        public String toString() {
            return "SystemTimeProvider{}";
        }
    }

    private static class SystemNanoTimeProvider
    implements TimeProvider {
        static final SystemNanoTimeProvider INSTANCE = new SystemNanoTimeProvider();

        private SystemNanoTimeProvider() {
        }

        @Override
        public long getTime() {
            return System.nanoTime();
        }

        public String toString() {
            return "SystemNanoTimeProvider{}";
        }
    }

    @NotThreadSafe
    private static class UnsharableCachedTimeProvider
    implements CachedTimeProvider {
        private long time;

        private UnsharableCachedTimeProvider(long time) {
            this.setTime(time);
        }

        @Override
        public void setTime(long curTime) {
            this.time = curTime;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        public String toString() {
            return "UnsharableCachedTimeProvider{curTime=" + this.time + "}";
        }
    }

    @NotThreadSafe
    private static class UnsharableTimepiece
    implements Timepiece {
        private long time;
        private long deltaTime;

        private UnsharableTimepiece() {
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getDeltaTime() {
            return this.deltaTime;
        }

        @Override
        public void update(long deltaTime) {
            if (deltaTime <= 0L) {
                this.deltaTime = 0L;
            } else {
                this.deltaTime = deltaTime;
                this.time += deltaTime;
            }
        }

        @Override
        public void setTime(long curTime) {
            this.time = curTime;
        }

        @Override
        public void setDeltaTime(long deltaTime) {
            UnsharableTimepiece.checkDeltaTime(deltaTime);
            this.deltaTime = deltaTime;
        }

        @Override
        public void restart(long curTime, long deltaTime) {
            UnsharableTimepiece.checkDeltaTime(deltaTime);
            this.time = curTime;
            this.deltaTime = deltaTime;
        }

        private static void checkDeltaTime(long deltaTime) {
            if (deltaTime < 0L) {
                throw new IllegalArgumentException("deltaTime must gte 0,  value " + deltaTime);
            }
        }
    }
}

