/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.io.ArrayPool;
import cn.wjybxx.base.io.ArrayPoolBuilder;
import cn.wjybxx.base.io.ArrayPoolCore;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentArrayPool<T>
implements ArrayPool<T> {
    public static final ConcurrentArrayPool<byte[]> SHARED_BYTE_ARRAY_POOL = ((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)ArrayPoolBuilder.newConcurrentBuilder(byte[].class).setPoolSize(16)).setDefCapacity(4096)).setMaxCapacity(524288)).setClear(false)).build();
    public static final ConcurrentArrayPool<char[]> SHARED_CHAR_ARRAY_POOL = ((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)((ArrayPoolBuilder.ConcurrentArrayPoolBuilder)ArrayPoolBuilder.newConcurrentBuilder(char[].class).setPoolSize(16)).setDefCapacity(1024)).setMaxCapacity(65536)).setClear(false)).build();
    private static final AtomicLong sequence = new AtomicLong(1L);
    private final Class<T> arrayType;
    private final int poolSize;
    private final int defCapacity;
    private final int maxCapacity;
    private final boolean clear;
    private final ConcurrentNavigableMap<ArrayPoolCore.Node<T>, Boolean> freeArrays;
    private final Consumer<T> clearHandler;

    public ConcurrentArrayPool(ArrayPoolBuilder.ConcurrentArrayPoolBuilder<T> builder) {
        Class arrayType = builder.getArrayType();
        if (arrayType.getComponentType() == null) {
            throw new IllegalArgumentException("arrayType");
        }
        if (builder.getPoolSize() < 0 || builder.getDefCapacity() <= 0 || builder.getMaxCapacity() <= 0) {
            throw new IllegalArgumentException();
        }
        this.arrayType = arrayType;
        this.poolSize = builder.getPoolSize();
        this.defCapacity = builder.getDefCapacity();
        this.maxCapacity = builder.getMaxCapacity();
        this.clear = builder.isClear();
        this.clearHandler = ArrayPoolCore.findClearHandler(arrayType);
        this.freeArrays = new ConcurrentSkipListMap(ArrayPoolCore.COMPARATOR);
    }

    @Override
    @Nonnull
    public T acquire() {
        Map.Entry firstEntry = this.freeArrays.pollFirstEntry();
        if (firstEntry != null) {
            return ((ArrayPoolCore.Node)firstEntry.getKey()).array();
        }
        return (T)Array.newInstance(this.arrayType.getComponentType(), this.defCapacity);
    }

    @Override
    public T acquire(int minimumLength) {
        return this.acquire(minimumLength, false);
    }

    @Override
    public T acquire(int minimumLength, boolean clear) {
        ArrayPoolCore.Node ceilingNode = this.freeArrays.ceilingKey(new ArrayPoolCore.LengthNode(minimumLength));
        if (ceilingNode != null) {
            this.freeArrays.remove(ceilingNode);
            Object array = ceilingNode.array();
            if (!this.clear && clear) {
                this.clearHandler.accept(array);
            }
            return array;
        }
        return (T)Array.newInstance(this.arrayType.getComponentType(), minimumLength);
    }

    @Override
    public void release(T array) {
        this.releaseImpl(array, this.clear);
    }

    @Override
    public void release(T array, boolean clear) {
        this.releaseImpl(array, this.clear || clear);
    }

    private void releaseImpl(T array, boolean clear) {
        int length = Array.getLength(array);
        if (length <= this.maxCapacity && this.freeArrays.size() < this.poolSize && clear) {
            this.clearHandler.accept(array);
        }
        this.freeArrays.put(new ArrayPoolCore.ArrayNode<T>(array, length, sequence.getAndIncrement()), Boolean.TRUE);
    }

    @Override
    public void clear() {
        this.freeArrays.clear();
    }
}

