/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.SystemPropsUtils;
import cn.wjybxx.base.io.ArrayPool;
import cn.wjybxx.base.io.SimpleArrayPool;

public class LocalByteArrayPool
implements ArrayPool<byte[]> {
    public static final LocalByteArrayPool INSTANCE = new LocalByteArrayPool();
    private static final int POOL_SIZE = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalByteArrayPool.PoolSize", 16);
    private static final int INIT_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalByteArrayPool.InitCapacity", 1024);
    private static final int MAX_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalByteArrayPool.MaxCapacity", 524288);
    private static final ThreadLocal<SimpleArrayPool<byte[]>> THREAD_LOCAL_INST = ThreadLocal.withInitial(() -> new SimpleArrayPool<byte[]>(byte[].class, POOL_SIZE, INIT_CAPACITY, MAX_CAPACITY));

    @Override
    public byte[] acquire() {
        return THREAD_LOCAL_INST.get().acquire();
    }

    @Override
    public byte[] acquire(int minimumLength) {
        return THREAD_LOCAL_INST.get().acquire(minimumLength);
    }

    @Override
    public byte[] acquire(int minimumLength, boolean clear) {
        return THREAD_LOCAL_INST.get().acquire(minimumLength, clear);
    }

    @Override
    public void release(byte[] array) {
        THREAD_LOCAL_INST.get().release(array);
    }

    @Override
    public void release(byte[] array, boolean clear) {
        THREAD_LOCAL_INST.get().release(array, clear);
    }

    @Override
    public void clear() {
    }

    public SimpleArrayPool<byte[]> localInst() {
        return THREAD_LOCAL_INST.get();
    }
}

