/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import java.util.Objects;
import java.util.random.RandomGenerator;

public class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static <T> boolean containsRef(T[] list, Object element) {
        return ArrayUtils.indexOfRef(list, element, 0) >= 0;
    }

    public static <T> int indexOfRef(T[] list, Object element) {
        return ArrayUtils.indexOfRef(list, element, 0);
    }

    public static <T> int indexOfRef(T[] list, Object element, int startIndex) {
        Objects.requireNonNull(list, "list");
        if (startIndex >= list.length) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int size = list.length;
        for (int i = startIndex; i < size; ++i) {
            if (list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOfRef(T[] list, Object element) {
        return ArrayUtils.lastIndexOfRef(list, element, Integer.MAX_VALUE);
    }

    public static <T> int lastIndexOfRef(T[] list, Object element, int startIndex) {
        Objects.requireNonNull(list, "list");
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= list.length) {
            startIndex = list.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static void swap(int[] array, int i, int j) {
        int value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(long[] array, int i, int j) {
        long value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(float[] array, int i, int j) {
        float value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(double[] array, int i, int j) {
        double value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void swap(Object[] array, int i, int j) {
        Object value = array[i];
        array[i] = array[j];
        array[j] = value;
    }

    public static void shuffle(int[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(long[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(float[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(double[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }

    public static void shuffle(Object[] array) {
        RandomGenerator rnd = RandomGenerator.getDefault();
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, rnd.nextInt(i));
        }
    }
}

