/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

public interface Constant
extends Comparable<Constant> {
    public int id();

    public String name();

    public Object declaringPool();

    public static String checkName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is empty ");
        }
        return name;
    }

    public static abstract class Builder {
        private Object declaringPool;
        private Integer id;
        private final String name;
        private int cacheIndex = -1;
        private boolean requireCacheIndex;

        public Builder(String name) {
            this.name = Constant.checkName(name);
        }

        public Builder setId(Object declaringPool, int id) {
            if (this.id != null) {
                throw new IllegalStateException("id cannot be initialized repeatedly");
            }
            this.declaringPool = declaringPool;
            this.id = id;
            return this;
        }

        public int getIdOrThrow() {
            if (this.id == null) {
                throw new IllegalStateException("id has not been initialized");
            }
            return this.id;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Object getDeclaringPool() {
            return this.declaringPool;
        }

        public Builder setCacheIndex(int cacheIndex) {
            this.cacheIndex = cacheIndex;
            return this;
        }

        public int getCacheIndex() {
            return this.cacheIndex;
        }

        public boolean isRequireCacheIndex() {
            return this.requireCacheIndex;
        }

        public Builder setRequireCacheIndex(boolean requireCacheIndex) {
            this.requireCacheIndex = requireCacheIndex;
            return this;
        }

        public abstract Constant build();
    }
}

