/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DelayedCompressList<E> {
    public static final int INDEX_NOT_FOUND = -1;
    private final ArrayList<E> children;
    private int recursionDepth;
    private transient int firstIndex = -1;
    private transient int lastIndex = -1;

    public DelayedCompressList() {
        this(4);
    }

    public DelayedCompressList(int initCapacity) {
        this.children = new ArrayList(initCapacity);
    }

    public DelayedCompressList(Collection<? extends E> src) {
        Preconditions.checkNullElements(src);
        this.children = new ArrayList<E>(src);
    }

    public void beginItr() {
        ++this.recursionDepth;
    }

    public void endItr() {
        if (this.recursionDepth == 0) {
            throw new IllegalStateException("begin must be called before end.");
        }
        --this.recursionDepth;
        if (this.recursionDepth == 0 && this.firstIndex != -1) {
            ArrayList<Object> children = this.children;
            int removed = this.lastIndex - this.firstIndex + 1;
            if (removed == 1) {
                children.remove(this.firstIndex);
            } else if (children.size() - removed <= 8) {
                children.removeIf(Objects::isNull);
            } else {
                children.subList(this.firstIndex, this.lastIndex + 1).removeIf(Objects::isNull);
            }
            this.firstIndex = -1;
            this.lastIndex = -1;
        }
    }

    public boolean isIterating() {
        return this.recursionDepth > 0;
    }

    public boolean isDelayed() {
        return this.firstIndex != -1;
    }

    public boolean add(E e) {
        Objects.requireNonNull(e);
        this.children.add(e);
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends E> c) {
        Preconditions.checkNullElements(c);
        return this.children.addAll(c);
    }

    @Nullable
    public E get(int index) {
        return this.children.get(index);
    }

    public E set(int index, E e) {
        Objects.requireNonNull(e);
        return this.children.set(index, e);
    }

    public E removeAt(int index) {
        ArrayList<E> children = this.children;
        if (children.size() == 0) {
            return null;
        }
        if (this.recursionDepth == 0) {
            return children.remove(index);
        }
        E removed = children.set(index, null);
        if (removed != null) {
            if (this.firstIndex == -1 || index < this.firstIndex) {
                this.firstIndex = index;
            }
            if (this.lastIndex == -1 || index > this.lastIndex) {
                this.lastIndex = index;
            }
        }
        return removed;
    }

    public void clear() {
        ArrayList<E> children = this.children;
        if (children.size() == 0) {
            return;
        }
        if (this.recursionDepth == 0) {
            children.clear();
            return;
        }
        this.firstIndex = 0;
        this.lastIndex = children.size() - 1;
        children.replaceAll(e -> null);
    }

    public boolean contains(Object e) {
        return this.index(e) >= 0;
    }

    public boolean containsRef(Object e) {
        return this.indexOfRef(e) >= 0;
    }

    public int index(@Nullable Object e) {
        if (e == null) {
            return this.firstIndex;
        }
        return this.children.indexOf(e);
    }

    public int lastIndex(@Nullable Object e) {
        if (e == null) {
            return this.lastIndex;
        }
        return this.children.lastIndexOf(e);
    }

    public int indexOfRef(@Nullable Object e) {
        if (e == null) {
            return this.firstIndex;
        }
        return CollectionUtils.indexOfRef(this.children, e);
    }

    public int lastIndexOfRef(@Nullable Object e) {
        if (e == null) {
            return this.lastIndex;
        }
        return CollectionUtils.lastIndexOfRef(this.children, e);
    }

    public int indexCustom(Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        int size = this.size();
        if (size == 0) {
            return -1;
        }
        for (int index = 0; index < size; ++index) {
            E e = this.get(index);
            if (e == null || !predicate.test(e)) continue;
            return index;
        }
        return -1;
    }

    public int lastIndexCustom(Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        int size = this.size();
        if (size == 0) {
            return -1;
        }
        for (int index = size - 1; index >= 0; --index) {
            E e = this.get(index);
            if (e == null || !predicate.test(e)) continue;
            return index;
        }
        return -1;
    }

    public boolean remove(Object e) {
        if (e == null) {
            return false;
        }
        int i = this.index(e);
        if (i >= 0) {
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public boolean removeRef(Object e) {
        if (e == null) {
            return false;
        }
        int i = this.indexOfRef(e);
        if (i >= 0) {
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public void sort(@Nonnull Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        this.ensureNotIterating();
        this.children.sort(comparator);
    }

    public int size() {
        return this.children.size();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public int realSize() {
        ArrayList<E> children = this.children;
        if (this.recursionDepth == 0 || this.firstIndex == -1) {
            return children.size();
        }
        int removed = this.lastIndex - this.firstIndex + 1;
        if (removed == 1) {
            return children.size() - 1;
        }
        int endIndex = this.lastIndex;
        for (int index = this.firstIndex; index <= endIndex; ++index) {
            if (children.get(index) == null) continue;
            --removed;
        }
        return children.size() - removed;
    }

    public boolean isRealEmpty() {
        ArrayList<E> children = this.children;
        int size = children.size();
        if (size == 0) {
            return true;
        }
        for (int index = 0; index < size; ++index) {
            if (children.get(index) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        ArrayList<E> children = this.children;
        int size = children.size();
        if (size == 0) {
            return;
        }
        this.beginItr();
        try {
            for (int index = 0; index < size; ++index) {
                E e = children.get(index);
                if (e == null) continue;
                action.accept(e);
            }
        }
        finally {
            this.endItr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(ObjIntConsumer<? super E> action) {
        Objects.requireNonNull(action);
        ArrayList<E> children = this.children;
        int size = children.size();
        if (size == 0) {
            return;
        }
        this.beginItr();
        try {
            for (int index = 0; index < size; ++index) {
                E e = children.get(index);
                if (e == null) continue;
                action.accept(e, index);
            }
        }
        finally {
            this.endItr();
        }
    }

    private void ensureNotIterating() {
        if (this.recursionDepth > 0) {
            throw new IllegalStateException("Invalid between iterating.");
        }
    }
}

