/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.io.ArrayBucketConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

final class ArrayPoolCore {
    private static final Consumer<Object> clear_objectArray = array -> Arrays.fill((Object[])array, null);
    private static final Consumer<Object> clear_charArray = array -> Arrays.fill((char[])array, '\u0000');
    private static final Consumer<Object> clear_intArray = array -> Arrays.fill((int[])array, 0);
    private static final Consumer<Object> clear_longArray = array -> Arrays.fill((long[])array, 0L);
    private static final Consumer<Object> clear_floatArray = array -> Arrays.fill((float[])array, 0.0f);
    private static final Consumer<Object> clear_doubleArray = array -> Arrays.fill((double[])array, 0.0);
    private static final Consumer<Object> clear_shortArray = array -> Arrays.fill((short[])array, (short)0);
    private static final Consumer<Object> clear_boolArray = array -> Arrays.fill((boolean[])array, false);
    private static final Consumer<Object> clear_byteArray = array -> Arrays.fill((byte[])array, (byte)0);

    ArrayPoolCore() {
    }

    public static boolean isRefArray(Class<?> arrayType) {
        return !arrayType.getComponentType().isPrimitive();
    }

    public static <T> Consumer<T> findClearHandler(Class<T> arrayType) {
        Class<?> componentType = arrayType.getComponentType();
        if (!componentType.isPrimitive()) {
            return clear_objectArray;
        }
        if (componentType == Byte.TYPE) {
            return clear_byteArray;
        }
        if (componentType == Character.TYPE) {
            return clear_charArray;
        }
        if (componentType == Integer.TYPE) {
            return clear_intArray;
        }
        if (componentType == Long.TYPE) {
            return clear_longArray;
        }
        if (componentType == Float.TYPE) {
            return clear_floatArray;
        }
        if (componentType == Double.TYPE) {
            return clear_doubleArray;
        }
        if (componentType == Short.TYPE) {
            return clear_shortArray;
        }
        if (componentType == Boolean.TYPE) {
            return clear_boolArray;
        }
        throw new IllegalArgumentException("Unsupported arrayType: " + arrayType.getSimpleName());
    }

    public static int[] calArrayCapacities(int defCapacity, int maxCapacity, double growFactor) {
        if (defCapacity < 0 || maxCapacity < defCapacity) {
            throw new IllegalArgumentException("defCapacity: %d, maxCapacity: %d".formatted(defCapacity, maxCapacity));
        }
        growFactor = Math.max(1.25, growFactor);
        ArrayList<Integer> capacityList = new ArrayList<Integer>();
        capacityList.add(defCapacity);
        long capacity = defCapacity;
        while (capacity < (long)maxCapacity) {
            capacity = (long)Math.min((double)maxCapacity, (double)capacity * growFactor);
            capacityList.add((int)capacity);
        }
        return capacityList.stream().mapToInt(e -> e).toArray();
    }

    public static int[] calArrayCacheCounts(int bucketCount, int firstBucketLength, double growFactor) {
        if (firstBucketLength < 0) {
            throw new IllegalArgumentException("firstBucketLength");
        }
        if (growFactor < 0.0) {
            throw new IllegalArgumentException("growFactor");
        }
        int[] result = new int[bucketCount];
        result[0] = firstBucketLength;
        for (int idx = 1; idx < bucketCount; ++idx) {
            long expectedLength = (long)((double)result[idx - 1] * growFactor);
            result[idx] = Math.clamp(expectedLength, 0, 0x40000000);
        }
        return result;
    }

    public static void initArrayCapacityAndCacheCounts(List<ArrayBucketConfig> bucketInfo, int[] arrayCapacities, int[] cacheCounts) {
        if (bucketInfo.size() != arrayCapacities.length || bucketInfo.size() != cacheCounts.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < bucketInfo.size(); ++i) {
            ArrayBucketConfig bucketConfig = bucketInfo.get(i);
            int arrayCapacity = bucketConfig.getArrayCapacity();
            int cacheCount = bucketConfig.getCacheCount();
            arrayCapacities[i] = arrayCapacity;
            cacheCounts[i] = cacheCount;
            if (i <= 0 || arrayCapacity > arrayCapacities[i - 1]) continue;
            throw new IllegalArgumentException("bucketInfo: " + String.valueOf(bucketInfo));
        }
    }

    public static int bucketIndexOfArray(int[] capacityArray, int arrayLength) {
        int index = Arrays.binarySearch(capacityArray, arrayLength);
        if (index < 0) {
            if (arrayLength > capacityArray[capacityArray.length - 1]) {
                return -1;
            }
            index = (index + 1) * -1;
        }
        return index;
    }
}

