/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.io.ArrayBucketConfig;
import cn.wjybxx.base.io.ArrayLikePool;
import cn.wjybxx.base.io.ArrayPoolCore;
import cn.wjybxx.base.io.MpmcArrayQueue;
import cn.wjybxx.base.io.PoolableArrayHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentArrayLikePool<T>
implements ArrayLikePool<T> {
    private final PoolableArrayHandler<T> handler;
    private final int lookAhead;
    private final int[] capacities;
    private final MpmcArrayQueue<T>[] buckets;

    public ConcurrentArrayLikePool(Builder<T> builder) {
        int[] arrayCacheCounts;
        int[] arrayCapacities;
        List<ArrayBucketConfig> bucketInfo = builder.getBucketInfo();
        if (bucketInfo.size() > 0) {
            arrayCapacities = new int[bucketInfo.size()];
            arrayCacheCounts = new int[bucketInfo.size()];
            ArrayPoolCore.initArrayCapacityAndCacheCounts(bucketInfo, arrayCapacities, arrayCacheCounts);
        } else {
            arrayCapacities = ArrayPoolCore.calArrayCapacities(builder.getDefCapacity(), builder.getMaxCapacity(), builder.getArrayGrowFactor());
            arrayCacheCounts = ArrayPoolCore.calArrayCacheCounts(arrayCapacities.length, builder.getFirstBucketLength(), builder.getBucketGrowFactor());
        }
        this.handler = builder.getHandler();
        this.lookAhead = Math.max(0, builder.getLookAhead());
        this.capacities = arrayCapacities;
        this.buckets = new MpmcArrayQueue[arrayCapacities.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new MpmcArrayQueue(arrayCacheCounts[i]);
        }
    }

    @Override
    @Nonnull
    public T acquire() {
        return this.acquire(this.capacities[0]);
    }

    @Override
    public T acquire(int minimumLength) {
        int index = ArrayPoolCore.bucketIndexOfArray(this.capacities, minimumLength);
        if (index < 0) {
            return this.handler.create(this, minimumLength);
        }
        T array = this.buckets[index].poll();
        if (array != null) {
            return array;
        }
        int end = Math.min(this.buckets.length, index + this.lookAhead + 1);
        for (int nextIndex = index + 1; nextIndex < end; ++nextIndex) {
            array = this.buckets[nextIndex].poll();
            if (array == null) continue;
            return array;
        }
        array = this.handler.create(this, this.capacities[index]);
        return array;
    }

    @Override
    public void release(T array) {
        int length = this.handler.getCapacity(array);
        int index = ArrayPoolCore.bucketIndexOfArray(this.capacities, length);
        if (index < 0 || length != this.capacities[index] || !this.handler.validate(array)) {
            this.handler.destroy(array);
            return;
        }
        this.handler.reset(array);
        if (!this.buckets[index].offer(array)) {
            this.handler.destroy(array);
        }
    }

    @Override
    public void clear() {
        for (MpmcArrayQueue<T> bucket : this.buckets) {
            T array;
            while ((array = bucket.poll()) != null) {
                this.handler.destroy(array);
            }
        }
    }

    public static <T> Builder<T> newBuilder(PoolableArrayHandler<T> handler) {
        return new Builder<T>(handler);
    }

    public static class Builder<T> {
        private final PoolableArrayHandler<T> handler;
        private int lookAhead = 1;
        private int defCapacity = 4096;
        private int maxCapacity = 65536;
        private double arrayGrowFactor = 2.0;
        private int firstBucketLength = 50;
        private double bucketGrowFactor = 1.0;
        private final List<ArrayBucketConfig> bucketInfo = new ArrayList<ArrayBucketConfig>();

        public Builder(PoolableArrayHandler<T> handler) {
            this.handler = Objects.requireNonNull(handler, "handler");
        }

        public ConcurrentArrayLikePool<T> build() {
            return new ConcurrentArrayLikePool(this);
        }

        public Builder<T> addBucket(int arrayCapacity, int cacheCount) {
            this.bucketInfo.add(new ArrayBucketConfig(arrayCapacity, cacheCount));
            return this;
        }

        public PoolableArrayHandler<T> getHandler() {
            return this.handler;
        }

        public int getDefCapacity() {
            return this.defCapacity;
        }

        public Builder<T> setDefCapacity(int defCapacity) {
            this.defCapacity = defCapacity;
            return this;
        }

        public int getMaxCapacity() {
            return this.maxCapacity;
        }

        public Builder<T> setMaxCapacity(int maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public int getFirstBucketLength() {
            return this.firstBucketLength;
        }

        public Builder<T> setFirstBucketLength(int firstBucketLength) {
            this.firstBucketLength = firstBucketLength;
            return this;
        }

        public double getArrayGrowFactor() {
            return this.arrayGrowFactor;
        }

        public Builder<T> setArrayGrowFactor(double arrayGrowFactor) {
            this.arrayGrowFactor = arrayGrowFactor;
            return this;
        }

        public double getBucketGrowFactor() {
            return this.bucketGrowFactor;
        }

        public Builder<T> setBucketGrowFactor(double bucketGrowFactor) {
            this.bucketGrowFactor = bucketGrowFactor;
            return this;
        }

        public int getLookAhead() {
            return this.lookAhead;
        }

        public Builder<T> setLookAhead(int lookAhead) {
            this.lookAhead = lookAhead;
            return this;
        }

        public List<ArrayBucketConfig> getBucketInfo() {
            return this.bucketInfo;
        }
    }
}

