/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.SystemPropsUtils;
import cn.wjybxx.base.io.ArrayBucketConfig;
import cn.wjybxx.base.io.ArrayPool;
import cn.wjybxx.base.io.ArrayPoolCore;
import cn.wjybxx.base.io.MpmcArrayQueue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentArrayPool<T>
implements ArrayPool<T> {
    public static final ConcurrentArrayPool<byte[]> SHARED_BYTE_ARRAY_POOL = ConcurrentArrayPool.newBuilder(byte[].class).setClear(false).setDefCapacity(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedByteArrayPool.DefCapacity", 4096)).setMaxCapacity(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedByteArrayPool.MaxCapacity", 524288)).setArrayGrowFactor(SystemPropsUtils.getDouble("Wjybxx.Commons.IO.SharedByteArrayPool.ArrayGrowFactor", 1.5)).setFirstBucketLength(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedByteArrayPool.FirstBucketLength", 50)).setBucketGrowFactor(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedByteArrayPool.BucketGrowFactor", 1)).build();
    public static final ConcurrentArrayPool<char[]> SHARED_CHAR_ARRAY_POOL = ConcurrentArrayPool.newBuilder(char[].class).setClear(false).setDefCapacity(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedCharArrayPool.DefCapacity", 1024)).setMaxCapacity(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedCharArrayPool.MaxCapacity", 65536)).setArrayGrowFactor(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedCharArrayPool.ArrayGrowFactor", 65536)).setFirstBucketLength(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedCharArrayPool.FirstBucketLength", 50)).setBucketGrowFactor(SystemPropsUtils.getInt("Wjybxx.Commons.IO.SharedCharArrayPool.BucketGrowFactor", 1)).build();
    private final Class<T> arrayType;
    private final Consumer<T> clearHandler;
    private final boolean clear;
    private final int lookAhead;
    private final int[] capacities;
    private final MpmcArrayQueue<T>[] buckets;

    public ConcurrentArrayPool(Builder<T> builder) {
        int[] arrayCacheCounts;
        int[] arrayCapacities;
        List<ArrayBucketConfig> bucketInfo = builder.getBucketInfo();
        if (bucketInfo.size() > 0) {
            arrayCapacities = new int[bucketInfo.size()];
            arrayCacheCounts = new int[bucketInfo.size()];
            ArrayPoolCore.initArrayCapacityAndCacheCounts(bucketInfo, arrayCapacities, arrayCacheCounts);
        } else {
            arrayCapacities = ArrayPoolCore.calArrayCapacities(builder.getDefCapacity(), builder.getMaxCapacity(), builder.getArrayGrowFactor());
            arrayCacheCounts = ArrayPoolCore.calArrayCacheCounts(arrayCapacities.length, builder.getFirstBucketLength(), builder.getBucketGrowFactor());
        }
        this.arrayType = builder.getArrayType();
        this.clearHandler = ArrayPoolCore.findClearHandler(builder.getArrayType());
        this.clear = builder.isClear();
        this.lookAhead = Math.max(0, builder.getLookAhead());
        this.capacities = arrayCapacities;
        this.buckets = new MpmcArrayQueue[arrayCapacities.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new MpmcArrayQueue(arrayCacheCounts[i]);
        }
    }

    @Override
    @Nonnull
    public T acquire() {
        return this.acquire(this.capacities[0], false);
    }

    @Override
    public T acquire(int minimumLength) {
        return this.acquire(minimumLength, false);
    }

    @Override
    public T acquire(int minimumLength, boolean clear) {
        int index = ArrayPoolCore.bucketIndexOfArray(this.capacities, minimumLength);
        if (index < 0) {
            return (T)Array.newInstance(this.arrayType.getComponentType(), minimumLength);
        }
        Object array = this.buckets[index].poll();
        if (array != null) {
            if (clear && !this.clear) {
                this.clearHandler.accept(array);
            }
            return array;
        }
        int end = Math.min(this.buckets.length, index + this.lookAhead + 1);
        for (int nextIndex = index + 1; nextIndex < end; ++nextIndex) {
            array = this.buckets[nextIndex].poll();
            if (array == null) continue;
            if (clear && !this.clear) {
                this.clearHandler.accept(array);
            }
            return array;
        }
        array = Array.newInstance(this.arrayType.getComponentType(), this.capacities[index]);
        return array;
    }

    @Override
    public void release(T array) {
        this.releaseImpl(array, this.clear);
    }

    @Override
    public void release(T array, boolean clear) {
        this.releaseImpl(array, this.clear || clear);
    }

    private void releaseImpl(T array, boolean clear) {
        int length = Array.getLength(array);
        int index = ArrayPoolCore.bucketIndexOfArray(this.capacities, length);
        if (index < 0 || length != this.capacities[index]) {
            return;
        }
        if (clear) {
            this.clearHandler.accept(array);
        }
        this.buckets[index].offer(array);
    }

    @Override
    public void clear() {
        for (MpmcArrayQueue<T> bucket : this.buckets) {
            while (bucket.poll() != null) {
            }
        }
    }

    public static <T> Builder<T> newBuilder(Class<T> arrayType) {
        return new Builder<T>(arrayType);
    }

    public static class Builder<T> {
        private final Class<T> arrayType;
        private boolean clear;
        private int lookAhead = 1;
        private int defCapacity = 4096;
        private int maxCapacity = 65536;
        private double arrayGrowFactor = 2.0;
        private int firstBucketLength = 50;
        private double bucketGrowFactor = 1.0;
        private final List<ArrayBucketConfig> bucketInfo = new ArrayList<ArrayBucketConfig>();

        private Builder(Class<T> arrayType) {
            this.arrayType = Objects.requireNonNull(arrayType, "arrayType");
            this.clear = ArrayPoolCore.isRefArray(arrayType);
        }

        public ConcurrentArrayPool<T> build() {
            return new ConcurrentArrayPool(this);
        }

        public Builder<T> addBucket(int arrayCapacity, int cacheCount) {
            this.bucketInfo.add(new ArrayBucketConfig(arrayCapacity, cacheCount));
            return this;
        }

        public Class<T> getArrayType() {
            return this.arrayType;
        }

        public int getDefCapacity() {
            return this.defCapacity;
        }

        public Builder<T> setDefCapacity(int defCapacity) {
            this.defCapacity = defCapacity;
            return this;
        }

        public int getMaxCapacity() {
            return this.maxCapacity;
        }

        public Builder<T> setMaxCapacity(int maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public boolean isClear() {
            return this.clear;
        }

        public Builder<T> setClear(boolean clear) {
            this.clear = clear;
            return this;
        }

        public int getFirstBucketLength() {
            return this.firstBucketLength;
        }

        public Builder<T> setFirstBucketLength(int firstBucketLength) {
            this.firstBucketLength = firstBucketLength;
            return this;
        }

        public double getArrayGrowFactor() {
            return this.arrayGrowFactor;
        }

        public Builder<T> setArrayGrowFactor(double arrayGrowFactor) {
            this.arrayGrowFactor = arrayGrowFactor;
            return this;
        }

        public double getBucketGrowFactor() {
            return this.bucketGrowFactor;
        }

        public Builder<T> setBucketGrowFactor(double bucketGrowFactor) {
            this.bucketGrowFactor = bucketGrowFactor;
            return this;
        }

        public int getLookAhead() {
            return this.lookAhead;
        }

        public Builder<T> setLookAhead(int lookAhead) {
            this.lookAhead = lookAhead;
            return this;
        }

        public List<ArrayBucketConfig> getBucketInfo() {
            return this.bucketInfo;
        }
    }
}

