/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.function.FunctionUtils;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SingleObjectPool<T>
implements ObjectPool<T> {
    private final Supplier<? extends T> factory;
    private final Consumer<? super T> resetPolicy;
    private T value;

    public SingleObjectPool(Supplier<? extends T> factory, Consumer<? super T> resetPolicy) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetPolicy = ObjectUtils.nullToDef(resetPolicy, FunctionUtils.emptyConsumer());
    }

    @Override
    public T get() {
        return this.acquire();
    }

    @Override
    public T acquire() {
        T result = this.value;
        if (result != null) {
            this.value = null;
        } else {
            result = this.factory.get();
        }
        return result;
    }

    @Override
    public void release(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        assert (object != this.value);
        this.resetPolicy.accept(object);
        this.value = object;
    }

    @Override
    public void releaseAll(Collection<? extends T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        for (T obj : objects) {
            if (null == obj) continue;
            assert (obj != this.value);
            this.resetPolicy.accept(obj);
            this.value = obj;
        }
    }

    @Override
    public void clear() {
        this.value = null;
    }
}

