/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.concurrent.CancelCodes;
import cn.wjybxx.btree.ICancelToken;
import cn.wjybxx.btree.ICancelTokenListener;
import cn.wjybxx.btree.Task;
import java.util.ArrayList;
import java.util.List;

public final class CancelToken
implements ICancelToken {
    private int code;
    private final List<ICancelTokenListener> listeners = new ArrayList<ICancelTokenListener>();
    private boolean firing = false;
    private short reentryId = 0;
    private static final ICancelTokenListener TOMBSTONE = cancelToken -> {};

    public CancelToken() {
    }

    public CancelToken(int code) {
        this.code = code;
    }

    @Override
    public void reset() {
        this.reentryId = (short)(this.reentryId + 1);
        this.code = 0;
        this.listeners.clear();
        this.firing = false;
    }

    @Override
    public int cancelCode() {
        return this.code;
    }

    @Override
    public boolean isCancelling() {
        return this.code != 0;
    }

    @Override
    public int reason() {
        return CancelCodes.getReason((int)this.code);
    }

    @Override
    public int degree() {
        return CancelCodes.getDegree((int)this.code);
    }

    @Override
    public int cancel() {
        return this.cancel(1);
    }

    @Override
    public int cancel(int cancelCode) {
        CancelCodes.checkCode((int)cancelCode);
        int r = this.code;
        if (r == 0) {
            this.code = cancelCode;
            CancelToken.postComplete(this);
        }
        return r;
    }

    private static void postComplete(CancelToken cancelToken) {
        List<ICancelTokenListener> listeners = cancelToken.listeners;
        if (listeners.isEmpty()) {
            return;
        }
        short reentryId = cancelToken.reentryId;
        cancelToken.firing = true;
        for (int idx = 0; idx < listeners.size(); ++idx) {
            ICancelTokenListener listener = listeners.set(idx, TOMBSTONE);
            try {
                listener.onCancelRequested(cancelToken);
            }
            catch (Exception e) {
                Task.logger.info("listener caught exception", (Throwable)e);
            }
            if (reentryId == cancelToken.reentryId) continue;
            return;
        }
        listeners.clear();
        cancelToken.firing = false;
    }

    @Override
    public void addListener(ICancelTokenListener listener) {
        if (listener == this) {
            throw new IllegalArgumentException("add this");
        }
        if (this.code != 0) {
            try {
                listener.onCancelRequested(this);
            }
            catch (Exception e) {
                Task.logger.info("listener caught exception", (Throwable)e);
            }
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean remListener(ICancelTokenListener listener) {
        return this.remListener(listener, false);
    }

    @Override
    public boolean remListener(ICancelTokenListener listener, boolean firstOccurrence) {
        int index;
        int n = index = firstOccurrence ? CollectionUtils.indexOfRef(this.listeners, (Object)listener) : CollectionUtils.lastIndexOfRef(this.listeners, (Object)listener);
        if (index < 0) {
            return false;
        }
        if (this.firing) {
            this.listeners.set(index, TOMBSTONE);
        } else {
            this.listeners.remove(index);
        }
        return true;
    }

    @Override
    public boolean hasListener(ICancelTokenListener listener) {
        return CollectionUtils.lastIndexOfRef(this.listeners, (Object)listener) >= 0;
    }

    @Override
    public ICancelToken newInstance() {
        return this.newInstance(false);
    }

    @Override
    public CancelToken newInstance(boolean copyCode) {
        return new CancelToken(copyCode ? this.code : 0);
    }

    @Override
    public void onCancelRequested(ICancelToken cancelToken) {
        this.cancel(cancelToken.cancelCode());
    }
}

