/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.base.MathCommon;
import cn.wjybxx.btree.ICancelToken;
import cn.wjybxx.btree.ICancelTokenListener;
import cn.wjybxx.btree.TaskEntry;
import cn.wjybxx.btree.TaskInlineHelper;
import cn.wjybxx.btree.TaskOverrides;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task<T>
implements ICancelTokenListener {
    public static final Logger logger = LoggerFactory.getLogger(Task.class);
    private static final int MASK_OVERRIDES = 31;
    private static final int MASK_PREV_STATUS = 992;
    private static final int OFFSET_PREV_STATUS = 5;
    private static final int MASK_INHERITED_BLACKBOARD = 1024;
    private static final int MASK_INHERITED_CANCEL_TOKEN = 2048;
    private static final int MASK_INHERITED_PROPS = 4096;
    private static final int MASK_ENTER_EXECUTE = 8192;
    private static final int MASK_EXECUTING = 16384;
    private static final int MASK_STOP_EXIT = 32768;
    private static final int MASK_STILLBORN = 65536;
    static final int MASK_DISABLE_NOTIFY = 131072;
    static final int MASK_CHECKING_GUARD = 262144;
    private static final int MASK_NOT_ACTIVE_SELF = 524288;
    private static final int MASK_NOT_ACTIVE_IN_HIERARCHY = 0x100000;
    private static final int MASK_REGISTERED_LISTENER = 0x200000;
    public static final int MASK_SLOW_START = 0x1000000;
    public static final int MASK_DISABLE_CHECK_CANCEL = 0x2000000;
    public static final int MASK_AUTO_LISTEN_CANCEL = 0x4000000;
    public static final int MASK_CANCEL_TOKEN_PER_CHILD = 0x8000000;
    public static final int MASK_BLACKBOARD_PER_CHILD = 0x10000000;
    public static final int MASK_AUTO_RESET_CHILDREN = 0x20000000;
    public static final int MASK_INVERTED_GUARD = 0x40000000;
    public static final int MASK_TAIL_CALL_RECURSION = Integer.MIN_VALUE;
    public static final int MASK_CONTROL_FLOW_OPTIONS = -16777216;
    private static final int MASK_GUARD_BASE_OPTIONS = -2113667072;
    private static final int MASK_BEFORE_ENTER_OPTIONS = 0x24000000;
    transient TaskEntry<T> taskEntry;
    transient Task<T> control;
    protected transient T blackboard;
    protected transient ICancelToken cancelToken;
    protected transient Object sharedProps;
    private transient Object controlData;
    private transient int status;
    private transient int ctl = TaskOverrides.maskOfTask(this.getClass());
    private transient int enterFrame;
    private transient int exitFrame;
    private transient short reentryId;
    private Task<T> guard;
    protected int flags;

    public final TaskEntry<T> getTaskEntry() {
        return this.taskEntry;
    }

    public final Task<T> getControl() {
        return this.control;
    }

    public final T getBlackboard() {
        return this.blackboard;
    }

    public final void setBlackboard(T blackboard) {
        this.blackboard = blackboard;
    }

    public final ICancelToken getCancelToken() {
        return this.cancelToken;
    }

    public final void setCancelToken(ICancelToken cancelToken) {
        this.cancelToken = cancelToken;
    }

    public final Object getControlData() {
        return this.controlData;
    }

    public final void setControlData(Object controlData) {
        this.controlData = controlData;
    }

    public final Object getSharedProps() {
        return this.sharedProps;
    }

    public final void setSharedProps(Object sharedProps) {
        this.sharedProps = sharedProps;
    }

    public final int getEnterFrame() {
        return this.enterFrame;
    }

    public final int getExitFrame() {
        return this.exitFrame;
    }

    public final void setEnterFrame(int enterFrame) {
        this.enterFrame = enterFrame;
    }

    public final void setExitFrame(int exitFrame) {
        this.exitFrame = exitFrame;
    }

    public final int getStatus() {
        return this.status;
    }

    public final int getNormalizedStatus() {
        return Math.min(this.status, 4);
    }

    public final boolean isRunning() {
        return this.status == 1;
    }

    public final boolean isCompleted() {
        return this.status >= 2;
    }

    public final boolean isSucceeded() {
        return this.status == 2;
    }

    public final boolean isCancelled() {
        return this.status == 3;
    }

    public final boolean isFailed() {
        return this.status > 3;
    }

    public final boolean isFailedOrCancelled() {
        return this.status >= 3;
    }

    public Object getEntity() {
        if (this.taskEntry == null) {
            throw new IllegalStateException("This task has never run");
        }
        return this.taskEntry.getEntity();
    }

    public final int getRunFrames() {
        if (this.status == 1) {
            return this.taskEntry.getCurFrame() - this.enterFrame;
        }
        return this.exitFrame - this.enterFrame;
    }

    public final int getPrevStatus() {
        return (this.ctl & 0x3E0) >> 5;
    }

    public final void setPrevStatus(int prevStatus) {
        prevStatus = MathCommon.clamp((int)prevStatus, (int)0, (int)31);
        this.ctl |= prevStatus << 5;
    }

    protected void beforeEnter() {
    }

    protected void enter(int reentryId) {
    }

    protected abstract void execute();

    protected void exit() {
    }

    public final void setSuccess() {
        assert (this.status == 1);
        this.status = 2;
        this.template_exit(0);
        if (Task.checkNotifyMask(this.ctl) && this.control != null) {
            this.control.onChildCompleted(this);
        }
    }

    public final void setCancelled() {
        this.setCompleted(3, false);
    }

    public final void setFailed(int status) {
        if (status < 4) {
            throw new IllegalArgumentException("status " + status);
        }
        this.setCompleted(status, false);
    }

    public final void setGuardFailed(Task<T> control) {
        assert (this.status != 1);
        if (control != null) {
            this.setControl(control);
        }
        this.setCompleted(5, false);
    }

    public final void setCompleted(int status, boolean fromChild) {
        int prevStatus;
        if (status < 2) {
            throw new IllegalArgumentException();
        }
        if (fromChild && status == 5) {
            status = 4;
        }
        if ((prevStatus = this.status) == 1) {
            if (status == 5) {
                throw new IllegalArgumentException("Running task cant fail with 'GUARD_FAILED'");
            }
            this.status = status;
            this.template_exit(0);
        } else {
            this.setPrevStatus(prevStatus);
            this.enterFrame = this.exitFrame;
            this.reentryId = (short)(this.reentryId + 1);
            this.status = status;
            this.ctl |= 0x10000;
        }
        if (Task.checkNotifyMask(this.ctl) && this.control != null) {
            this.control.onChildCompleted(this);
        }
    }

    protected abstract void onChildRunning(Task<T> var1);

    protected abstract void onChildCompleted(Task<T> var1);

    public final void onEvent(@Nonnull Object event) {
        if (this.canHandleEvent(event)) {
            this.onEventImpl(event);
        }
    }

    public boolean canHandleEvent(@Nonnull Object event) {
        return this.status == 1;
    }

    protected abstract void onEventImpl(@Nonnull Object var1);

    @Override
    public void onCancelRequested(ICancelToken cancelToken) {
        if (this.isRunning()) {
            this.setCancelled();
        }
    }

    public final void stop() {
        if (this.status == 1) {
            this.status = 3;
            this.template_exit(32768);
        } else if (this.status != 0) {
            this.ctl |= 0x8000;
        }
    }

    protected void stopRunningChildren() {
        for (int idx = this.getChildCount() - 1; idx >= 0; --idx) {
            Task<T> child = this.getChild(idx);
            if (child.status != 1) continue;
            child.stop();
        }
    }

    public void resetForRestart() {
        if (this.status == 0) {
            return;
        }
        if (this.status == 1) {
            this.stop();
        }
        this.resetChildrenForRestart();
        if (this.guard != null) {
            this.guard.resetForRestart();
        }
        if (this != this.taskEntry) {
            this.unsetControl();
        }
        this.status = 0;
        this.ctl &= 0x1F;
        this.enterFrame = 0;
        this.exitFrame = 0;
        this.reentryId = (short)(this.reentryId + 1);
    }

    protected void resetChildrenForRestart() {
        for (int idx = this.getChildCount() - 1; idx >= 0; --idx) {
            Task<T> child = this.getChild(idx);
            if (child.status == 0) continue;
            child.resetForRestart();
        }
    }

    public final boolean isActiveSelf() {
        return (this.ctl & 0x80000) == 0;
    }

    public final boolean isActiveInHierarchy() {
        return (this.ctl & 0x100000) == 0;
    }

    public final void setActive(boolean value) {
        if (this.isActiveSelf() == value) {
            return;
        }
        this.setCtlBit(524288, !value);
        this.refreshActiveInHierarchy();
    }

    public final void refreshActiveInHierarchy() {
        boolean newState;
        boolean bl = newState = this.isActiveSelf() && (this.control == null || this.control.isActiveInHierarchy());
        if (newState == this.isActiveInHierarchy()) {
            return;
        }
        this.setCtlBit(0x100000, !newState);
        if (this.status == 1) {
            this.refreshChildrenActiveInHierarchy();
        }
    }

    protected void refreshChildrenActiveInHierarchy() {
        for (int idx = 0; idx < this.getChildCount(); ++idx) {
            Task<T> child = this.getChild(idx);
            if (child.status != 1) continue;
            child.refreshActiveInHierarchy();
        }
    }

    public final void registerCancelListener() {
        this.cancelToken.addListener(this);
        this.ctl |= 0x200000;
    }

    public final boolean checkCancel(int rid) {
        if (rid != this.reentryId) {
            return true;
        }
        if (this.cancelToken.isCancelling()) {
            this.setCancelled();
            return true;
        }
        return false;
    }

    public final int getReentryId() {
        return this.reentryId;
    }

    public final boolean isExited(int rid) {
        return rid != this.reentryId;
    }

    protected final boolean isExecuting() {
        return (this.ctl & 0x4000) != 0;
    }

    public final boolean isExecuteTriggeredByEnter() {
        return (this.ctl & 0x2000) != 0;
    }

    public final boolean isExitTriggeredByStop() {
        return (this.ctl & 0x8000) != 0;
    }

    public final boolean isStillborn() {
        return (this.ctl & 0x10000) != 0;
    }

    private static boolean checkNotifyMask(int ctl) {
        return (ctl & 0x28000) == 0;
    }

    private static boolean checkSlowStart(int ctl) {
        if ((ctl & 0x40000) != 0) {
            return false;
        }
        return (ctl & 0x1100000) != 0;
    }

    public final void setSlowStart(boolean disable) {
        this.setCtlBit(0x1000000, disable);
    }

    public final boolean isSlowStart() {
        return (this.ctl & 0x1000000) != 0;
    }

    public final void setDisableCheckCancel(boolean value) {
        this.setCtlBit(0x2000000, value);
    }

    public final boolean isDisableCheckCancel() {
        return (this.ctl & 0x2000000) != 0;
    }

    private boolean isAutoCheckCancel() {
        return (this.ctl & 0x2000000) == 0;
    }

    public final void setAutoListenCancel(boolean enable) {
        this.setCtlBit(0x4000000, enable);
    }

    public final boolean isAutoListenCancel() {
        return (this.ctl & 0x4000000) != 0;
    }

    public final void setCancelTokenPerChild(boolean value) {
        this.setCtlBit(0x8000000, value);
    }

    public final boolean isCancelTokenPerChild() {
        return (this.ctl & 0x8000000) != 0;
    }

    public final void setBlackboardPerChild(boolean value) {
        this.setCtlBit(0x10000000, value);
    }

    public final boolean isBlackboardPerChild() {
        return (this.ctl & 0x10000000) != 0;
    }

    public final void setAutoResetChildren(boolean enable) {
        this.setCtlBit(0x20000000, enable);
    }

    public final boolean isAutoResetChildren() {
        return (this.ctl & 0x20000000) != 0;
    }

    public final void setInvertedGuard(boolean enable) {
        this.setCtlBit(0x40000000, enable);
    }

    public final boolean isInvertedGuard() {
        return (this.ctl & 0x40000000) != 0;
    }

    public final void setTailRecursion(boolean enable) {
        this.setCtlBit(Integer.MIN_VALUE, enable);
    }

    public final boolean isTailRecursion() {
        return (this.ctl & Integer.MIN_VALUE) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void template_enterExecute(Task<T> control, int initMask) {
        if (control != null) {
            initMask |= this.captureContext(control);
            initMask |= control.ctl & 0x100000;
        }
        initMask |= this.ctl & 0x1F;
        this.ctl = initMask |= this.flags & 0xFF000000;
        ICancelToken cancelToken = this.cancelToken;
        if (cancelToken.isCancelling()) {
            this.releaseContext();
            this.setCompleted(3, false);
            return;
        }
        int prevStatus = Math.min(31, this.status);
        initMask |= prevStatus << 5;
        this.ctl = initMask |= 0x6000;
        this.status = 1;
        this.enterFrame = this.exitFrame = this.taskEntry.getCurFrame();
        short reentryId = this.reentryId = (short)(this.reentryId + 1);
        try {
            if ((initMask & 1) != 0) {
                this.beforeEnter();
            }
            if ((this.ctl & 0x24000000) != 0) {
                if (this.isAutoResetChildren()) {
                    this.resetChildrenForRestart();
                }
                if (this.isAutoListenCancel()) {
                    cancelToken.addListener(this);
                    this.ctl |= 0x200000;
                }
            }
            if ((initMask & 2) != 0) {
                this.enter(reentryId);
                if (reentryId != this.reentryId) {
                    return;
                }
                if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
                    this.setCancelled();
                    return;
                }
            }
            if (Task.checkSlowStart(this.ctl)) {
                this.checkFireRunningAndCancel(control, cancelToken);
                return;
            }
            this.execute();
            if (reentryId == this.reentryId) {
                this.checkFireRunningAndCancel(control, cancelToken);
            }
        }
        finally {
            if (reentryId == this.reentryId) {
                this.ctl &= 0xFFFF9FFF;
            }
        }
    }

    private void checkFireRunningAndCancel(Task<T> control, ICancelToken cancelToken) {
        if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
            this.setCancelled();
            return;
        }
        if (Task.checkNotifyMask(this.ctl) && control != null) {
            control.onChildRunning(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void template_execute(boolean fromControl) {
        assert (this.status == 1);
        if ((this.ctl & 0x100000) != 0 && fromControl) {
            return;
        }
        ICancelToken cancelToken = this.cancelToken;
        if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
            this.setCancelled();
            return;
        }
        short reentryId = this.reentryId;
        if ((this.ctl & 0x4000) != 0) {
            this.execute();
            if (reentryId == this.reentryId && cancelToken.isCancelling() && this.isAutoCheckCancel()) {
                this.setCancelled();
            }
            return;
        }
        this.ctl |= 0x4000;
        try {
            this.execute();
            if (reentryId == this.reentryId && cancelToken.isCancelling() && this.isAutoCheckCancel()) {
                this.setCancelled();
            }
        }
        finally {
            if (reentryId == this.reentryId) {
                this.ctl &= 0xFFFFBFFF;
            }
        }
    }

    private void template_exit(int extraMask) {
        if (extraMask != 0) {
            this.ctl |= extraMask;
        }
        this.exitFrame = this.taskEntry.getCurFrame();
        if ((this.ctl & 0x200000) != 0) {
            this.cancelToken.remListener(this);
        }
        try {
            this.stopRunningChildren();
            if ((this.ctl & 4) != 0) {
                this.exit();
            }
        }
        finally {
            this.ctl &= 0xFFFF9FFF;
            this.reentryId = (short)(this.reentryId + 1);
            this.releaseContext();
        }
    }

    public final void template_runChild(Task<T> child) {
        assert (this.isReady()) : "Task is not ready";
        if (child.status == 1) {
            child.template_execute(true);
        } else if (child.guard == null || this.template_checkGuard(child.guard)) {
            int initMask = (this.ctl & 0x40000) == 0 ? 0 : -2113667072;
            child.template_enterExecute(this, initMask);
        } else {
            child.setGuardFailed(this);
        }
    }

    public final void template_runChildDirectly(Task<T> child) {
        assert (this.isReady()) : "Task is not ready";
        if (child.status == 1) {
            child.template_execute(true);
        } else {
            int initMask = (this.ctl & 0x40000) == 0 ? 0 : -2113667072;
            child.template_enterExecute(this, initMask);
        }
    }

    public final void template_runHook(Task<T> hook) {
        assert (this.isReady()) : "Task is not ready";
        if (hook.status == 1) {
            hook.template_execute(true);
        } else if (hook.guard == null || this.template_checkGuard(hook.guard)) {
            hook.template_enterExecute(this, 131072);
        } else {
            hook.setGuardFailed(this);
        }
    }

    public final void template_runHookDirectly(Task<T> hook) {
        assert (this.isReady()) : "Task is not ready";
        if (hook.status == 1) {
            hook.template_execute(true);
        } else {
            hook.template_enterExecute(this, 131072);
        }
    }

    public final void template_runInlinedChild(Task<T> inlinedChild, TaskInlineHelper<T> helper, Task<T> runningChild) {
        int runningChildReentryId = runningChild.getReentryId();
        int inlinedChildReentryId = inlinedChild.getReentryId();
        inlinedChild.template_execute(true);
        if (inlinedChild.getReentryId() != inlinedChildReentryId && runningChild.getReentryId() == runningChildReentryId) {
            helper.inlineChild(runningChild);
        }
    }

    public final boolean template_checkGuard(@Nullable Task<T> guard) {
        assert (this.isReady()) : "Task is not ready";
        if (guard == null) {
            return true;
        }
        try {
            if (guard.guard != null && !this.template_checkGuard(guard.guard)) {
                boolean bl = false;
                return bl;
            }
            guard.template_enterExecute(this, -2113536000);
            switch (guard.getNormalizedStatus()) {
                case 2: {
                    boolean bl = (guard.ctl & 0x40000000) == 0;
                    return bl;
                }
                case 4: {
                    boolean bl = (guard.ctl & 0x40000000) != 0;
                    return bl;
                }
            }
            throw new IllegalStateException("Illegal guard status '%d'. Guards must either succeed or fail in one step.".formatted(guard.getStatus()));
        }
        finally {
            guard.unsetControl();
        }
    }

    private int captureContext(Task<T> control) {
        this.taskEntry = control.taskEntry;
        this.control = control;
        int r = 0;
        if (this.blackboard == null) {
            this.blackboard = Objects.requireNonNull(control.blackboard);
            r |= 0x400;
        }
        if (this.cancelToken == null) {
            this.cancelToken = Objects.requireNonNull(control.cancelToken);
            r |= 0x800;
        }
        if (this.sharedProps == null && control.sharedProps != null) {
            this.sharedProps = control.sharedProps;
            r |= 0x1000;
        }
        return r;
    }

    private void releaseContext() {
        int ctl = this.ctl;
        if ((ctl & 0x400) != 0) {
            this.blackboard = null;
        }
        if ((ctl & 0x800) != 0) {
            this.cancelToken = null;
        }
        if ((ctl & 0x1000) != 0) {
            this.sharedProps = null;
        }
    }

    public final void setControl(Task<T> control) {
        assert (control != this);
        if (this == this.taskEntry) {
            throw new Error();
        }
        this.taskEntry = Objects.requireNonNull(control.taskEntry);
        this.control = control;
    }

    public final void unsetControl() {
        if (this == this.taskEntry) {
            throw new Error();
        }
        this.taskEntry = null;
        this.control = null;
        this.blackboard = null;
        this.cancelToken = null;
        this.sharedProps = null;
        this.controlData = null;
    }

    public final int addChild(Task<T> task) {
        this.checkAddChild(task);
        return this.addChildImpl(task);
    }

    public final Task<T> setChild(int index, Task<T> newTask) {
        this.checkAddChild(newTask);
        return this.setChildImpl(index, newTask);
    }

    private void checkAddChild(Task<T> child) {
        if (child == null) {
            throw new NullPointerException("child");
        }
        if (child == this) {
            throw new IllegalArgumentException("add self to children");
        }
        if (child.isRunning()) {
            throw new IllegalArgumentException("child is running");
        }
        if (child.control != this && (child.taskEntry != null || child.control != null)) {
            throw new IllegalArgumentException("child.control is not null");
        }
    }

    public final boolean removeChild(Task<?> task) {
        if (null == task) {
            throw new NullPointerException("task");
        }
        int index = this.indexChild(task);
        if (index > 0) {
            this.removeChildImpl(index);
            task.unsetControl();
            return true;
        }
        return false;
    }

    public final Task<T> removeChild(int index) {
        Task<T> child = this.removeChildImpl(index);
        child.unsetControl();
        return child;
    }

    public final void removeAllChild() {
        for (int idx = this.getChildCount() - 1; idx >= 0; --idx) {
            this.removeChildImpl(idx).unsetControl();
        }
    }

    public int indexChild(Task<?> task) {
        for (int idx = this.getChildCount() - 1; idx >= 0; --idx) {
            if (this.getChild(idx) != task) continue;
            return idx;
        }
        return -1;
    }

    public abstract Stream<Task<T>> childStream();

    public abstract int getChildCount();

    public abstract Task<T> getChild(int var1);

    protected abstract int addChildImpl(Task<T> var1);

    protected abstract Task<T> setChildImpl(int var1, Task<T> var2);

    protected abstract Task<T> removeChildImpl(int var1);

    public final boolean isInlinable() {
        return (this.ctl & 0x10) != 0;
    }

    public final int getControlFlowOptions() {
        return this.ctl & 0xFF000000;
    }

    public final void exportControlFlowOptions() {
        int controlFlowOptions = this.ctl & 0xFF000000;
        this.flags &= 0xFFFFFF;
        this.flags |= controlFlowOptions;
    }

    public final void setChildCancelToken(Task<T> child, ICancelToken childCancelToken) {
        if (childCancelToken != null && childCancelToken != this.cancelToken) {
            this.cancelToken.addListener(childCancelToken);
        }
        child.cancelToken = childCancelToken;
    }

    public final void unsetChildCancelToken(Task<T> child) {
        ICancelToken childCancelToken = child.cancelToken;
        if (childCancelToken != null && childCancelToken != this.cancelToken) {
            this.cancelToken.remListener(childCancelToken);
            childCancelToken.reset();
        }
        child.cancelToken = null;
    }

    public static void stop(@Nullable Task<?> task) {
        if (task != null && task.status == 1) {
            task.stop();
        }
    }

    public static void resetForRestart(@Nullable Task<?> task) {
        if (task != null && task.status != 0) {
            task.resetForRestart();
        }
    }

    private boolean isReady() {
        if (this.isRunning()) {
            return true;
        }
        if (this == this.taskEntry) {
            return this.taskEntry.isInited();
        }
        return this.taskEntry != null && this.control != null && this.blackboard != null && this.cancelToken != null;
    }

    private void setCtlBit(int mask, boolean enable) {
        this.ctl = enable ? (this.ctl |= mask) : (this.ctl &= ~mask);
    }

    private boolean getCtlBit(int mask) {
        return (this.ctl & mask) != 0;
    }

    public final Task<T> getGuard() {
        return this.guard;
    }

    public final Task<T> setGuard(Task<T> guard) {
        this.guard = guard;
        return this;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final Task<T> setFlags(int flags) {
        this.flags = flags;
        return this;
    }
}

