/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;

public abstract class LoopDecorator<T>
extends Decorator<T> {
    protected int maxLoop = -1;
    protected transient int curLoop = 0;

    public LoopDecorator() {
    }

    public LoopDecorator(Task<T> child) {
        super(child);
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        this.curLoop = 0;
    }

    @Override
    protected void execute() {
        if (this.isTailRecursion()) {
            int reentryId = this.getReentryId();
            do {
                Task inlinedRunningChild;
                if ((inlinedRunningChild = this.inlineHelper.getInlinedRunningChild()) != null) {
                    this.template_runInlinedChild(inlinedRunningChild, this.inlineHelper, this.child);
                } else if (this.child.isRunning()) {
                    this.child.template_execute(true);
                } else {
                    ++this.curLoop;
                    this.template_runChild(this.child);
                }
                if (!this.checkCancel(reentryId)) continue;
                return;
            } while (!this.child.isRunning());
            return;
        }
        Task inlinedRunningChild = this.inlineHelper.getInlinedRunningChild();
        if (inlinedRunningChild != null) {
            this.template_runInlinedChild(inlinedRunningChild, this.inlineHelper, this.child);
        } else if (this.child.isRunning()) {
            this.child.template_execute(true);
        } else {
            ++this.curLoop;
            this.template_runChild(this.child);
        }
    }

    protected boolean hasNextLoop() {
        return this.maxLoop <= 0 || this.curLoop < this.maxLoop;
    }

    public int getMaxLoop() {
        return this.maxLoop;
    }

    public void setMaxLoop(int maxLoop) {
        this.maxLoop = maxLoop;
    }
}

