/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.fsm.StateMachineHandler;
import cn.wjybxx.btree.fsm.StateMachineTask;

public class StateMachineHandlers {
    public static <T> StateMachineHandler<T> defaultHandler() {
        return DefaultHandler.INST;
    }

    public static <T> StateMachineHandler<T> redoHandler() {
        return RedoHandler.INST;
    }

    public static <T> StateMachineHandler<T> undoHandler() {
        return UndoHandler.INST;
    }

    private static class DefaultHandler<T>
    implements StateMachineHandler<T> {
        private static final DefaultHandler<?> INST = new DefaultHandler();

        private DefaultHandler() {
        }

        @Override
        public final void beforeChangeState(StateMachineTask<T> stateMachineTask, Task<T> curState, Task<T> nextState) {
        }

        @Override
        public final void resetForRestart(StateMachineTask<T> stateMachineTask) {
        }

        @Override
        public final void beforeEnter(StateMachineTask<T> stateMachineTask) {
        }

        @Override
        public final int onChildCompleted(StateMachineTask<T> stateMachineTask, Task<T> curState) {
            return 1;
        }
    }

    public static class RedoHandler<T>
    implements StateMachineHandler<T> {
        private static final RedoHandler<?> INST = new RedoHandler();

        @Override
        public boolean onNextStateAbsent(StateMachineTask<T> stateMachineTask, Task<T> preState) {
            if (stateMachineTask.redoChangeState()) {
                return true;
            }
            stateMachineTask.setCompleted(preState.getStatus(), true);
            return true;
        }

        @Override
        public final void beforeChangeState(StateMachineTask<T> stateMachineTask, Task<T> curState, Task<T> nextState) {
        }

        @Override
        public final void resetForRestart(StateMachineTask<T> stateMachineTask) {
        }

        @Override
        public final void beforeEnter(StateMachineTask<T> stateMachineTask) {
        }

        @Override
        public final int onChildCompleted(StateMachineTask<T> stateMachineTask, Task<T> curState) {
            return 1;
        }
    }

    private static class UndoHandler<T>
    implements StateMachineHandler<T> {
        private static final UndoHandler<?> INST = new UndoHandler();

        private UndoHandler() {
        }

        @Override
        public boolean onNextStateAbsent(StateMachineTask<T> stateMachineTask, Task<T> preState) {
            if (stateMachineTask.undoChangeState()) {
                return true;
            }
            stateMachineTask.setCompleted(preState.getStatus(), true);
            return true;
        }

        @Override
        public final void beforeChangeState(StateMachineTask<T> stateMachineTask, Task<T> curState, Task<T> nextState) {
        }

        @Override
        public final void resetForRestart(StateMachineTask<T> stateMachineTask) {
        }

        @Override
        public final void beforeEnter(StateMachineTask<T> stateMachineTask) {
        }

        @Override
        public final int onChildCompleted(StateMachineTask<T> stateMachineTask, Task<T> curState) {
            return 1;
        }
    }
}

