/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.collection.SmallArrayList;
import cn.wjybxx.base.concurrent.CancelCodes;
import cn.wjybxx.btree.ICancelTokenListener;
import cn.wjybxx.btree.Task;
import java.util.List;
import java.util.Objects;

public class CancelToken
implements ICancelTokenListener {
    private int code;
    private final List<ICancelTokenListener> listeners = new SmallArrayList();
    private boolean firing = false;
    private short reentryId = 0;
    private static final ICancelTokenListener TOMBSTONE = cancelToken -> {};

    public CancelToken() {
    }

    public CancelToken(int code) {
        this.code = code;
    }

    public CancelToken newInstance() {
        return this.newInstance(false);
    }

    public CancelToken newInstance(boolean copyCode) {
        return new CancelToken(copyCode ? this.code : 0);
    }

    public void reset() {
        this.reentryId = (short)(this.reentryId + 1);
        this.code = 0;
        this.listeners.clear();
        this.firing = false;
    }

    protected final int getReentryId() {
        return this.reentryId;
    }

    protected final boolean isFiring() {
        return this.firing;
    }

    public final int cancelCode() {
        return this.code;
    }

    public final boolean isCancelling() {
        return this.code != 0;
    }

    public final int reason() {
        return CancelCodes.getReason((int)this.code);
    }

    public final int degree() {
        return CancelCodes.getDegree((int)this.code);
    }

    public final boolean cancel() {
        return this.cancel(1);
    }

    public final boolean cancel(int cancelCode) {
        CancelCodes.checkCode((int)cancelCode);
        int r = this.code;
        if (r == 0) {
            this.code = cancelCode;
            CancelToken.postComplete(this);
            return true;
        }
        return false;
    }

    private static void postComplete(CancelToken cancelToken) {
        List<ICancelTokenListener> listeners = cancelToken.listeners;
        if (listeners.isEmpty()) {
            return;
        }
        short reentryId = cancelToken.reentryId;
        cancelToken.firing = true;
        for (int idx = 0; idx < listeners.size(); ++idx) {
            ICancelTokenListener listener = listeners.set(idx, TOMBSTONE);
            try {
                listener.onCancelRequested(cancelToken);
            }
            catch (Throwable e) {
                Task.logger.info("listener caught exception", e);
            }
            if (reentryId == cancelToken.reentryId) continue;
            return;
        }
        listeners.clear();
        cancelToken.firing = false;
    }

    public final void addListener(ICancelTokenListener listener) {
        Objects.requireNonNull(listener);
        if (listener == this) {
            throw new IllegalArgumentException("add self");
        }
        if (this.code != 0) {
            try {
                listener.onCancelRequested(this);
            }
            catch (Throwable e) {
                Task.logger.info("listener caught exception", e);
            }
        } else {
            this.listeners.add(listener);
        }
    }

    public final boolean remListener(ICancelTokenListener listener) {
        return this.remListener(listener, false);
    }

    public final boolean remListener(ICancelTokenListener listener, boolean firstOccurrence) {
        int index;
        int n = index = firstOccurrence ? CollectionUtils.indexOfRef(this.listeners, (Object)listener) : CollectionUtils.lastIndexOfRef(this.listeners, (Object)listener);
        if (index < 0) {
            return false;
        }
        if (this.firing) {
            this.listeners.set(index, TOMBSTONE);
        } else {
            this.listeners.remove(index);
        }
        return true;
    }

    public final boolean hasListener(ICancelTokenListener listener) {
        return CollectionUtils.lastIndexOfRef(this.listeners, (Object)listener) >= 0;
    }

    @Override
    public final void onCancelRequested(CancelToken cancelToken) {
        this.cancel(cancelToken.cancelCode());
    }
}

