/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlineHelper;
import cn.wjybxx.btree.TaskVisitor;
import javax.annotation.Nonnull;

public abstract class Decorator<T>
extends Task<T> {
    protected Task<T> child;
    protected final transient TaskInlineHelper<T> inlineHelper = new TaskInlineHelper();

    public Decorator() {
    }

    public Decorator(Task<T> child) {
        this.child = child;
    }

    public final TaskInlineHelper<T> getInlineHelper() {
        return this.inlineHelper;
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.inlineHelper.stopInline();
    }

    @Override
    protected void beforeEnter() {
    }

    @Override
    protected void exit() {
        this.inlineHelper.stopInline();
    }

    @Override
    protected void stopRunningChildren() {
        Task.stop(this.child);
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        Task<T> inlinedChild = this.inlineHelper.getInlinedRunningChild();
        if (inlinedChild != null) {
            inlinedChild.onEvent(event);
        } else if (this.child != null) {
            this.child.onEvent(event);
        }
    }

    @Override
    protected void onChildRunning(Task<T> child) {
    }

    @Override
    public void visitChildren(TaskVisitor<? super T> visitor, Object param) {
        if (this.child != null) {
            visitor.visitChild(this.child, 0, param);
        }
    }

    @Override
    public final int indexChild(Task<?> task) {
        if (task != null && task == this.child) {
            return 0;
        }
        return -1;
    }

    @Override
    public final int getChildCount() {
        return this.child == null ? 0 : 1;
    }

    @Override
    public final Task<T> getChild(int index) {
        if (index == 0 && this.child != null) {
            return this.child;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final int addChildImpl(Task<T> task) {
        if (this.child != null) {
            throw new IllegalStateException("Decorator cannot have more than one child");
        }
        this.child = task;
        return 0;
    }

    @Override
    protected final Task<T> setChildImpl(int index, Task<T> task) {
        if (index == 0 && this.child != null) {
            Task<T> r = this.child;
            this.child = task;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final Task<T> removeChildImpl(int index) {
        if (index == 0 && this.child != null) {
            Task<T> r = this.child;
            this.child = null;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }

    public Task<T> getChild() {
        return this.child;
    }

    public void setChild(Task<T> child) {
        this.child = child;
    }
}

