/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.SingleRunningChildBranch;

public class TaskInlineHelper<T> {
    public static boolean enableInline = true;
    private static final int INVALID_REENTRY_ID = Integer.MIN_VALUE;
    private static final int FAILED_REENTRY_ID = -2147483647;
    private transient Task<T> inlinedRunningChild = null;
    private transient int inlinedReentryId = Integer.MIN_VALUE;

    public final Task<T> getInlinedRunningChild() {
        Task<T> r = this.inlinedRunningChild;
        if (r == null) {
            return null;
        }
        if (r.getReentryId() == this.inlinedReentryId) {
            return r;
        }
        this.inlinedRunningChild = null;
        this.inlinedReentryId = Integer.MIN_VALUE;
        return null;
    }

    public final void stopInline() {
        this.inlinedRunningChild = null;
        this.inlinedReentryId = Integer.MIN_VALUE;
    }

    public final void inlineChild(Task<T> runningChild) {
        if (!runningChild.isRunning()) {
            throw new IllegalArgumentException("runningChild must running");
        }
        if (!enableInline) {
            this.inlinedRunningChild = null;
            this.inlinedReentryId = Integer.MIN_VALUE;
            return;
        }
        Task cur = runningChild;
        while (cur.isInlinable()) {
            Decorator decorator;
            if (cur instanceof SingleRunningChildBranch) {
                SingleRunningChildBranch branch = cur;
                if (branch.getRunningChild() == null || branch.getRunningChild().isCompleted() || (cur = branch.getInlineHelper().getInlinedRunningChild()) != null) break;
                if (branch.getInlineHelper().inlinedReentryId == -2147483647) {
                    cur = branch;
                    break;
                }
                cur = branch.getRunningChild();
                continue;
            }
            if (!(cur instanceof Decorator) || (decorator = (Decorator)cur).getChild() == null || decorator.getChild().isCompleted() || (cur = decorator.getInlineHelper().getInlinedRunningChild()) != null) break;
            if (decorator.getInlineHelper().inlinedReentryId == -2147483647) {
                cur = decorator;
                break;
            }
            cur = decorator.getChild();
        }
        assert (cur.isRunning());
        if (cur == runningChild) {
            this.inlinedRunningChild = null;
            this.inlinedReentryId = -2147483647;
        } else {
            this.inlinedRunningChild = cur;
            this.inlinedReentryId = cur.getReentryId();
        }
    }
}

