/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.SingleRunningChildBranch;
import java.util.List;

public class ActiveSelector<T>
extends SingleRunningChildBranch<T> {
    public ActiveSelector() {
    }

    public ActiveSelector(List<Task<T>> children) {
        super(children);
    }

    @Override
    protected void execute() {
        Task childToRun = null;
        int childIndex = -1;
        for (int idx = 0; idx < this.children.size(); ++idx) {
            Task child = (Task)this.children.get(idx);
            if (!this.template_checkGuard(child.getGuard())) continue;
            childToRun = child;
            childIndex = idx;
            break;
        }
        if (childToRun == null) {
            ActiveSelector.stop(this.runningChild);
            this.setFailed(4);
            return;
        }
        Task runningChild = this.runningChild;
        if (runningChild == childToRun) {
            Task inlinedRunningChild = this.inlineHelper.getInlinedRunningChild();
            if (inlinedRunningChild != null) {
                this.template_runInlinedChild(inlinedRunningChild, this.inlineHelper, runningChild);
            } else if (runningChild.isRunning()) {
                runningChild.template_execute(true);
            } else {
                this.template_startChild(runningChild, false);
            }
        } else {
            if (runningChild != null) {
                runningChild.stop();
                this.inlineHelper.stopInline();
            }
            this.runningChild = childToRun;
            this.runningIndex = childIndex;
            this.template_startChild(childToRun, false);
        }
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        this.runningChild = null;
        this.inlineHelper.stopInline();
        this.setCompleted(child.getStatus(), true);
    }
}

