/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.JoinPolicy;
import cn.wjybxx.btree.branch.Parallel;
import cn.wjybxx.btree.branch.ParallelChildHelper;
import cn.wjybxx.btree.branch.join.JoinSequence;
import java.util.List;
import javax.annotation.Nonnull;

public class Join<T>
extends Parallel<T> {
    protected JoinPolicy<T> policy;
    protected transient int completedCount;
    protected transient int succeededCount;

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.completedCount = 0;
        this.succeededCount = 0;
        this.policy.resetForRestart();
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        if (this.policy == null) {
            this.policy = JoinSequence.getInstance();
        }
        this.completedCount = 0;
        this.succeededCount = 0;
        this.policy.beforeEnter(this);
    }

    @Override
    protected void enter(int reentryId) {
        this.initChildHelpers(this.isCancelTokenPerChild());
        this.policy.enter(this);
    }

    @Override
    protected void execute() {
        List children = this.children;
        if (children.isEmpty()) {
            return;
        }
        int reentryId = this.getReentryId();
        for (int i = 0; i < children.size(); ++i) {
            Task inlinedRunningChild;
            Task child = (Task)children.get(i);
            ParallelChildHelper childHelper = Join.getChildHelper(child);
            boolean started = child.isExited(childHelper.reentryId);
            if (started) {
                if (child.isCompleted()) {
                    continue;
                }
            } else {
                this.setChildCancelToken(child, childHelper.cancelToken);
            }
            if ((inlinedRunningChild = childHelper.getInlinedRunningChild()) != null) {
                this.template_runInlinedChild(inlinedRunningChild, childHelper, child);
            } else if (child.isRunning()) {
                child.template_execute(true);
            } else {
                this.template_startChild(child, true);
            }
            if (!this.checkCancel(reentryId)) continue;
            return;
        }
        if (this.completedCount >= children.size()) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        ParallelChildHelper<T> helper = Join.getChildHelper(child);
        helper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        ParallelChildHelper<T> helper = Join.getChildHelper(child);
        helper.stopInline();
        this.unsetChildCancelToken(child);
        ++this.completedCount;
        if (child.isSucceeded()) {
            ++this.succeededCount;
        }
        this.policy.onChildCompleted(this, child);
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        this.policy.onEvent(this, event);
    }

    public boolean isAllChildCompleted() {
        return this.completedCount >= this.children.size();
    }

    public boolean isAllChildSucceeded() {
        return this.succeededCount >= this.children.size();
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getSucceededCount() {
        return this.succeededCount;
    }

    public JoinPolicy<T> getPolicy() {
        return this.policy;
    }

    public void setPolicy(JoinPolicy<T> policy) {
        this.policy = policy;
    }
}

