/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlinable;
import cn.wjybxx.btree.branch.SingleRunningChildBranch;
import java.util.List;
import javax.annotation.Nullable;

@TaskInlinable
public class SelectorN<T>
extends SingleRunningChildBranch<T> {
    private int required = 1;
    private boolean failFast;
    private transient int count;

    public SelectorN() {
    }

    public SelectorN(List<Task<T>> children) {
        super(children);
    }

    public SelectorN(Task<T> first, @Nullable Task<T> second) {
        super(first, second);
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.count = 0;
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        this.count = 0;
    }

    @Override
    protected void enter(int reentryId) {
        if (this.required < 1) {
            this.setSuccess();
        } else if (this.getChildCount() == 0) {
            this.setFailed(6);
        } else if (this.checkFailFast()) {
            this.setFailed(7);
        } else if (this.isCheckingGuard()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Task child = (Task)this.children.get(i);
                if (!this.template_checkGuard(child) || ++this.count < this.required) continue;
                this.setSuccess();
                return;
            }
            this.setFailed(4);
        }
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        this.runningChild = null;
        this.inlineHelper.stopInline();
        if (child.isCancelled()) {
            this.setCancelled();
            return;
        }
        if (child.isSucceeded() && ++this.count >= this.required) {
            this.setSuccess();
        } else if (this.isAllChildCompleted() || this.checkFailFast()) {
            this.setFailed(4);
        } else {
            this.template_execute(false);
        }
    }

    private boolean checkFailFast() {
        return this.failFast && this.children.size() - this.getCompletedCount() < this.required - this.count;
    }

    public int getRequired() {
        return this.required;
    }

    public void setRequired(int required) {
        this.required = required;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }
}

