/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.BranchTask;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlineHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SingleRunningChildBranch<T>
extends BranchTask<T> {
    protected transient int runningIndex = -1;
    protected transient Task<T> runningChild = null;
    protected final transient TaskInlineHelper<T> inlineHelper = new TaskInlineHelper();

    public SingleRunningChildBranch() {
    }

    public SingleRunningChildBranch(List<Task<T>> children) {
        super(children);
    }

    public SingleRunningChildBranch(Task<T> first, @Nullable Task<T> second) {
        super(first, second);
    }

    public final int getRunningIndex() {
        return this.runningIndex;
    }

    public final Task<T> getRunningChild() {
        return this.runningChild;
    }

    public final TaskInlineHelper<T> getInlineHelper() {
        return this.inlineHelper;
    }

    public boolean isAllChildCompleted() {
        return this.runningIndex + 1 >= this.children.size();
    }

    public int getCompletedCount() {
        return this.runningIndex + 1;
    }

    public int getSucceededCount() {
        int r = 0;
        for (int i = 0; i < this.runningIndex; ++i) {
            if (!((Task)this.children.get(i)).isSucceeded()) continue;
            ++r;
        }
        return r;
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.runningIndex = -1;
        this.runningChild = null;
        this.inlineHelper.stopInline();
    }

    @Override
    protected void beforeEnter() {
        this.runningIndex = -1;
        this.runningChild = null;
    }

    @Override
    protected void exit() {
        this.runningChild = null;
        this.inlineHelper.stopInline();
    }

    @Override
    protected void stopRunningChildren() {
        Task.stop(this.runningChild);
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        Task<T> inlinedChild = this.inlineHelper.getInlinedRunningChild();
        if (inlinedChild != null) {
            inlinedChild.onEvent(event);
        } else if (this.runningChild != null) {
            this.runningChild.onEvent(event);
        }
    }

    @Override
    protected void execute() {
        Task<T> runningChild = this.runningChild;
        if (runningChild == null) {
            runningChild = this.nextChild();
            this.runningChild = runningChild;
            this.template_startChild(runningChild, true);
        } else {
            Task<T> inlinedChild = this.inlineHelper.getInlinedRunningChild();
            if (inlinedChild != null) {
                this.template_runInlinedChild(inlinedChild, this.inlineHelper, runningChild);
            } else if (runningChild.isRunning()) {
                runningChild.template_execute(true);
            } else {
                this.template_startChild(runningChild, true);
            }
        }
    }

    protected Task<T> nextChild() {
        int nextIndex = this.runningIndex + 1;
        if (nextIndex < this.children.size()) {
            this.runningIndex = nextIndex;
            return (Task)this.children.get(nextIndex);
        }
        throw new IllegalStateException(this.illegalStateMsg());
    }

    protected final String illegalStateMsg() {
        return "numChildren: %d, currentIndex: %d".formatted(this.children.size(), this.runningIndex);
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        this.runningChild = child;
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        this.runningChild = null;
        this.inlineHelper.stopInline();
    }
}

