/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlinable;

@TaskInlinable
public class AlwaysRunning<T>
extends Decorator<T> {
    private transient int childPrevReentryId;

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        this.childPrevReentryId = this.child == null ? 0 : this.child.getReentryId();
    }

    @Override
    protected void execute() {
        Task child = this.child;
        if (child == null) {
            return;
        }
        boolean started = child.isExited(this.childPrevReentryId);
        if (started && child.isCompleted()) {
            return;
        }
        Task inlinedRunningChild = this.inlineHelper.getInlinedRunningChild();
        if (inlinedRunningChild != null) {
            this.template_runInlinedChild(inlinedRunningChild, this.inlineHelper, child);
        } else if (child.isRunning()) {
            child.template_execute(true);
        } else {
            this.template_startChild(child, true);
        }
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        this.inlineHelper.stopInline();
        if (child.isCancelled()) {
            this.setCancelled();
        }
    }
}

