/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlinable;
import cn.wjybxx.btree.decorator.LoopDecorator;

@TaskInlinable
public class Repeat<T>
extends LoopDecorator<T> {
    public static final int MODE_ALWAYS = 0;
    public static final int MODE_ONLY_SUCCESS = 1;
    public static final int MODE_ONLY_FAILED = 2;
    public static final int MODE_NEVER = 3;
    private int countMode = 0;
    private int required = 1;
    private transient int count;

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.count = 0;
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        if (this.required < -1) {
            throw new IllegalStateException("required < -1");
        }
        this.count = 0;
    }

    @Override
    protected void enter(int reentryId) {
        super.enter(reentryId);
        if (this.required == 0) {
            this.setSuccess();
        }
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        boolean match;
        this.inlineHelper.stopInline();
        if (child.isCancelled()) {
            this.setCancelled();
            return;
        }
        switch (this.countMode) {
            case 0: {
                boolean bl = true;
                break;
            }
            case 1: {
                boolean bl = child.isSucceeded();
                break;
            }
            case 2: {
                boolean bl = child.isFailed();
                break;
            }
            default: {
                boolean bl = match = false;
            }
        }
        if (match) {
            ++this.count;
            if (this.required >= 0 && this.count >= this.required) {
                this.setSuccess();
                return;
            }
        }
        if (!this.hasNextLoop()) {
            this.setFailed(9);
        } else {
            this.template_execute(false);
        }
    }

    public int getCountMode() {
        return this.countMode;
    }

    public void setCountMode(int countMode) {
        this.countMode = countMode;
    }

    public int getRequired() {
        return this.required;
    }

    public void setRequired(int required) {
        this.required = required;
    }
}

