/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlinable;

@TaskInlinable
public class SubtreeRef<T>
extends Decorator<T> {
    private String subtreeName;

    public SubtreeRef() {
    }

    public SubtreeRef(String subtreeName) {
        this.subtreeName = subtreeName;
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        if (this.child == null) {
            Task rootTask = this.getTaskEntry().getTreeLoader().loadRootTask(this.subtreeName);
            this.addChild(rootTask);
        }
    }

    @Override
    protected void execute() {
        Task inlinedRunningChild = this.inlineHelper.getInlinedRunningChild();
        if (inlinedRunningChild != null) {
            this.template_runInlinedChild(inlinedRunningChild, this.inlineHelper, this.child);
        } else if (this.child.isRunning()) {
            this.child.template_execute(true);
        } else {
            this.template_startChild(this.child, true);
        }
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        this.inlineHelper.stopInline();
        this.setCompleted(child.getStatus(), true);
    }

    public String getSubtreeName() {
        return this.subtreeName;
    }

    public void setSubtreeName(String subtreeName) {
        this.subtreeName = subtreeName;
    }
}

