/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

public final class ChangeStateArgs {
    public static final byte CMD_NONE = 0;
    public static final byte CMD_UNDO = 1;
    public static final byte CMD_REDO = 2;
    public static final byte DELAY_NONE = 0;
    public static final byte DELAY_CURRENT_COMPLETED = 1;
    public static final ChangeStateArgs PLAIN = new ChangeStateArgs(0, 0, 0, null);
    public static final ChangeStateArgs PLAIN_WHEN_COMPLETED = new ChangeStateArgs(0, 1, 0, null);
    public static final ChangeStateArgs UNDO = new ChangeStateArgs(1, 0, 0, null);
    public static final ChangeStateArgs UNDO_WHEN_COMPLETED = new ChangeStateArgs(1, 1, 0, null);
    public static final ChangeStateArgs REDO = new ChangeStateArgs(2, 0, 0, null);
    public static final ChangeStateArgs REDO_WHEN_COMPLETED = new ChangeStateArgs(2, 1, 0, null);
    public final byte cmd;
    public final byte delayMode;
    public final int delayArg;
    public final Object extraInfo;

    private ChangeStateArgs(byte cmd, byte delayMode, int delayArg, Object extraInfo) {
        this.delayMode = delayMode;
        this.cmd = cmd;
        this.delayArg = delayArg;
        this.extraInfo = extraInfo;
    }

    public boolean isPlain() {
        return this.cmd == 0;
    }

    public boolean isUndo() {
        return this.cmd == 1;
    }

    public boolean isRedo() {
        return this.cmd == 2;
    }

    public ChangeStateArgs with(byte delayMode) {
        if (delayMode == this.delayMode) {
            return this;
        }
        return new ChangeStateArgs(this.cmd, delayMode, this.delayArg, this.extraInfo);
    }

    public ChangeStateArgs with(byte delayMode, int delayArg) {
        if (delayMode == this.delayMode && delayArg == this.delayArg) {
            return this;
        }
        return new ChangeStateArgs(this.cmd, delayMode, delayArg, this.extraInfo);
    }

    public ChangeStateArgs with(byte delayMode, int delayArg, Object extraInfo) {
        return new ChangeStateArgs(this.cmd, delayMode, delayArg, extraInfo);
    }

    public ChangeStateArgs withExtraInfo(Object extraInfo) {
        if (extraInfo == this.extraInfo) {
            return this;
        }
        return new ChangeStateArgs(this.cmd, this.delayMode, this.delayArg, extraInfo);
    }
}

