/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class BranchTask<T>
extends Task<T> {
    protected List<Task<T>> children;

    public BranchTask() {
        this.children = new ArrayList<Task<T>>(4);
    }

    public BranchTask(List<Task<T>> children) {
        this.children = Objects.requireNonNull(children);
    }

    public BranchTask(Task<T> first, @Nullable Task<T> second) {
        Objects.requireNonNull(first);
        this.children = new ArrayList<Task<T>>(2);
        this.children.add(first);
        if (second != null) {
            this.children.add(second);
        }
    }

    public final boolean isFirstChild(Task<?> child) {
        if (this.children.isEmpty()) {
            return false;
        }
        return this.children.get(0) == child;
    }

    public final boolean isLastChild(Task<?> child) {
        if (this.children.isEmpty()) {
            return false;
        }
        return this.children.getLast() == child;
    }

    public final Task<T> getFirstChild() {
        return this.children.getFirst();
    }

    public final Task<T> getLastChild() {
        return this.children.getLast();
    }

    public final void shuffleChild() {
        Collections.shuffle(this.children);
    }

    @Override
    public final int indexChild(Task<?> task) {
        return CollectionUtils.indexOfRef(this.children, task);
    }

    @Override
    public void visitChildren(TaskVisitor<? super T> visitor, Object param) {
        for (int i = 0; i < this.children.size(); ++i) {
            visitor.visitChild(this.children.get(i), i, param);
        }
    }

    @Override
    public final int getChildCount() {
        return this.children.size();
    }

    @Override
    public final Task<T> getChild(int index) {
        return this.children.get(index);
    }

    @Override
    protected final int addChildImpl(Task<T> task) {
        this.children.add(task);
        return this.children.size() - 1;
    }

    @Override
    protected final Task<T> setChildImpl(int index, Task<T> task) {
        return this.children.set(index, task);
    }

    @Override
    protected final Task<T> removeChildImpl(int index) {
        return this.children.remove(index);
    }

    public List<Task<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<Task<T>> children) {
        if (children == null) {
            this.children.clear();
        } else {
            this.children = children;
        }
    }
}

