/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskVisitor;

public class TaskVisitors {
    public static <T> TaskVisitor<T> refreshActive() {
        return RefreshActiveVisitor.INST;
    }

    public static <T> TaskVisitor<T> resetForRestart() {
        return ResetForRestartVisitor.INST;
    }

    private static class RefreshActiveVisitor<T>
    implements TaskVisitor<T> {
        private static final RefreshActiveVisitor<?> INST = new RefreshActiveVisitor();

        private RefreshActiveVisitor() {
        }

        @Override
        public void visitChild(Task<? extends T> child, int index, Object param) {
            if (child.isRunning()) {
                child.refreshActiveInHierarchy();
            }
        }

        @Override
        public void visitHook(Task<? extends T> child, Object param) {
            if (child.isRunning()) {
                child.refreshActiveInHierarchy();
            }
        }
    }

    private static class ResetForRestartVisitor<T>
    implements TaskVisitor<T> {
        private static final ResetForRestartVisitor<?> INST = new ResetForRestartVisitor();

        private ResetForRestartVisitor() {
        }

        @Override
        public void visitChild(Task<? extends T> child, int index, Object param) {
            child.resetForRestart();
        }

        @Override
        public void visitHook(Task<? extends T> child, Object param) {
            child.resetForRestart();
        }
    }
}

