/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlinable;

@TaskInlinable
public class AlwaysRunning<T>
extends Decorator<T> {
    private transient boolean started;

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        this.started = false;
        if (this.child == null) {
            this.setBreakInline(true);
        }
    }

    @Override
    protected void execute() {
        Task child = this.child;
        if (child == null) {
            return;
        }
        if (this.started && child.isCompleted()) {
            return;
        }
        Task inlinedChild = this.inlineHelper.getInlinedChild();
        if (inlinedChild != null) {
            inlinedChild.template_executeInlined(this.inlineHelper, child);
        } else if (child.isRunning()) {
            child.template_execute(true);
        } else {
            this.started = true;
            this.template_startChild(child, true);
        }
    }

    @Override
    protected void onChildRunning(Task<T> child, boolean starting) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        this.inlineHelper.stopInline();
        this.setBreakInline(true);
        if (child.isCancelled()) {
            this.setCancelled();
        }
    }
}

