/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.btree.LeafTask;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.fsm.ChangeStateArgs;
import cn.wjybxx.btree.fsm.StateMachineTask;
import javax.annotation.Nonnull;

public class ChangeStateTask<T>
extends LeafTask<T> {
    private String nextStateGuid;
    private transient Task<T> nextState;
    private Object stateProps;
    private String machineName;
    private byte delayMode;
    private int delayArg;

    public ChangeStateTask() {
    }

    public ChangeStateTask(Task<T> nextState) {
        this.nextState = nextState;
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        if (this.nextState != null && this.nextState.getControl() == null) {
            this.nextState.resetForRestart();
        }
    }

    @Override
    protected void execute() {
        if (this.nextState == null) {
            if (ObjectUtils.isEmpty((CharSequence)this.nextStateGuid)) {
                throw new IllegalStateException("guid is empty");
            }
            this.nextState = this.getTaskEntry().getTreeLoader().loadRootTask(this.nextStateGuid);
        }
        if (this.stateProps != null) {
            this.nextState.setSharedProps(this.stateProps);
        }
        int reentryId = this.getReentryId();
        StateMachineTask<T> stateMachine = StateMachineTask.findStateMachine(this, this.machineName);
        if (this.delayMode == 0) {
            stateMachine.changeState(this.nextState, this.delayArg);
        } else {
            stateMachine.changeState(this.nextState, ChangeStateArgs.PLAIN.with(this.delayMode, this.delayArg));
        }
        if (!this.isExited(reentryId)) {
            this.setSuccess();
        }
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
    }

    public String getNextStateGuid() {
        return this.nextStateGuid;
    }

    public void setNextStateGuid(String nextStateGuid) {
        this.nextStateGuid = nextStateGuid;
    }

    public Task<T> getNextState() {
        return this.nextState;
    }

    public void setNextState(Task<T> nextState) {
        this.nextState = nextState;
    }

    public Object getStateProps() {
        return this.stateProps;
    }

    public void setStateProps(Object stateProps) {
        this.stateProps = stateProps;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public byte getDelayMode() {
        return this.delayMode;
    }

    public void setDelayMode(byte delayMode) {
        this.delayMode = delayMode;
    }

    public int getDelayArg() {
        return this.delayArg;
    }

    public void setDelayArg(int delayArg) {
        this.delayArg = delayArg;
    }
}

