/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.fsm.ChangeStateArgs;
import cn.wjybxx.btree.fsm.StateMachineHandler;
import cn.wjybxx.btree.fsm.StateMachineHandlers;
import java.util.Objects;
import javax.annotation.Nonnull;

public class StateMachineTask<T>
extends Decorator<T> {
    private String name;
    protected Task<T> initState;
    protected Object initStateProps;
    protected transient Task<T> tempNextState;
    protected transient StateMachineHandler<T> handler = StateMachineHandlers.defaultHandler();

    public final Task<T> getCurState() {
        return this.child;
    }

    public final Task<T> getNextState() {
        return this.tempNextState;
    }

    public final Task<T> discardNextState() {
        Task<T> r = this.tempNextState;
        if (r != null) {
            this.tempNextState = null;
        }
        return r;
    }

    public final boolean undoChangeState() {
        return this.undoChangeState(ChangeStateArgs.UNDO);
    }

    public boolean undoChangeState(ChangeStateArgs changeStateArgs) {
        return false;
    }

    public final boolean redoChangeState() {
        return this.redoChangeState(ChangeStateArgs.REDO);
    }

    public boolean redoChangeState(ChangeStateArgs changeStateArgs) {
        return false;
    }

    public final void changeState(Task<T> nextState) {
        this.changeState(nextState, ChangeStateArgs.PLAIN);
    }

    public final void changeState(Task<T> nextState, int curStateResult) {
        ChangeStateArgs changeStateArgs = switch (curStateResult) {
            case 2 -> ChangeStateArgs.PLAIN_SUCCESS;
            case 3 -> ChangeStateArgs.PLAIN_CANCELLED;
            case 4 -> ChangeStateArgs.PLAIN_ERROR;
            default -> ChangeStateArgs.PLAIN.withArg(curStateResult);
        };
        this.changeState(nextState, changeStateArgs);
    }

    public final void changeState(Task<T> nextState, ChangeStateArgs changeStateArgs) {
        Objects.requireNonNull(nextState, "nextState");
        Objects.requireNonNull(changeStateArgs, "changeStateArgs");
        nextState.setControlData(changeStateArgs);
        this.tempNextState = nextState;
        if (this.isRunning() && this.handler.isReady(this, this.child, nextState)) {
            this.template_execute(false);
        }
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.handler.resetForRestart(this);
        if (this.initState != null) {
            this.initState.resetForRestart();
        }
        this.tempNextState = null;
        if (this.child != null) {
            this.removeChild(0);
        }
    }

    @Override
    protected void beforeEnter() {
        this.handler.beforeEnter(this);
        if (this.initState != null && this.initStateProps != null) {
            this.initState.setSharedProps(this.initStateProps);
        }
        if (this.tempNextState == null && this.initState != null) {
            this.tempNextState = this.initState;
        }
        if (this.tempNextState != null && this.tempNextState.getControlData() == null) {
            this.tempNextState.setControlData(ChangeStateArgs.PLAIN);
        }
    }

    @Override
    protected void exit() {
        this.tempNextState = null;
        if (this.child != null) {
            this.removeChild(0);
        }
        super.exit();
    }

    @Override
    protected void execute() {
        Task curState = this.child;
        Task<T> nextState = this.tempNextState;
        if (nextState != null && this.handler.isReady(this, curState, nextState)) {
            this.stopCurState(curState, (ChangeStateArgs)nextState.getControlData());
            this.tempNextState = null;
            if (curState != null) {
                this.setChild(0, nextState);
            } else {
                this.addChild(nextState);
            }
            this.beforeChangeState(curState, nextState);
            nextState.setControlData(null);
            this.template_startChild(nextState, true);
            return;
        }
        if (curState == null) {
            return;
        }
        Task inlinedChild = this.inlineHelper.getInlinedChild();
        if (inlinedChild != null) {
            inlinedChild.template_executeInlined(this.inlineHelper, curState);
        } else if (curState.isRunning()) {
            curState.template_execute(true);
        } else {
            this.template_startChild(curState, true);
        }
    }

    private void stopCurState(Task<T> curState, ChangeStateArgs changeStateArgs) {
        if (curState == null) {
            return;
        }
        if (changeStateArgs.delayMode == 0 && changeStateArgs.delayArg > 0) {
            curState.stop(changeStateArgs.delayArg);
        } else {
            curState.stop();
        }
        this.inlineHelper.stopInline();
    }

    protected void beforeChangeState(Task<T> curState, Task<T> nextState) {
        assert (curState != null || nextState != null);
        this.handler.beforeChangeState(this, curState, nextState);
    }

    @Override
    protected void onChildRunning(Task<T> child, boolean starting) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        assert (this.child == child);
        this.inlineHelper.stopInline();
        if (this.tempNextState != null) {
            this.template_execute(false);
            return;
        }
        if (this.handler.onNextStateAbsent(this, child)) {
            return;
        }
        this.removeChild(0);
        this.beforeChangeState(child, null);
    }

    public static <T> StateMachineTask<T> findStateMachine(Task<T> task) {
        Task<T> control;
        while ((control = task.getControl()) != null) {
            if (control instanceof StateMachineTask) {
                StateMachineTask stateMachineTask = (StateMachineTask)control;
                return stateMachineTask;
            }
            Task<T> eldestBrother = control.getChild(0);
            if (eldestBrother instanceof StateMachineTask) {
                StateMachineTask stateMachineTask = (StateMachineTask)eldestBrother;
                return stateMachineTask;
            }
            task = control;
        }
        throw new IllegalStateException("cant find stateMachine from controls");
    }

    @Nonnull
    public static <T> StateMachineTask<T> findStateMachine(Task<T> task, String name) {
        Task<T> control;
        if (ObjectUtils.isBlank((String)name)) {
            return StateMachineTask.findStateMachine(task);
        }
        while ((control = task.getControl()) != null) {
            StateMachineTask<T> stateMachine = StateMachineTask.castAsStateMachine(control, name);
            if (stateMachine != null) {
                return stateMachine;
            }
            int n = control.getChildCount();
            for (int i = 0; i < n; ++i) {
                Task<T> brother = control.getChild(i);
                stateMachine = StateMachineTask.castAsStateMachine(brother, name);
                if (stateMachine == null) continue;
                return stateMachine;
            }
            task = control;
        }
        throw new IllegalStateException("cant find stateMachine from controls and brothers");
    }

    private static <T> StateMachineTask<T> castAsStateMachine(Task<T> task, String name) {
        StateMachineTask stateMachineTask;
        if (task instanceof StateMachineTask && Objects.equals(name, (stateMachineTask = (StateMachineTask)task).getName())) {
            return stateMachineTask;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Task<T> getInitState() {
        return this.initState;
    }

    public void setInitState(Task<T> initState) {
        this.initState = initState;
    }

    public Object getInitStateProps() {
        return this.initStateProps;
    }

    public void setInitStateProps(Object initStateProps) {
        this.initStateProps = initStateProps;
    }

    public StateMachineHandler<T> getHandler() {
        return this.handler;
    }

    public void setHandler(StateMachineHandler<T> handler) {
        this.handler = handler == null ? StateMachineHandlers.defaultHandler() : handler;
    }
}

