/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskInlinable;
import cn.wjybxx.btree.branch.SingleRunningChildBranch;
import cn.wjybxx.btree.branch.SwitchHandler;

@TaskInlinable
public class Switch<T>
extends SingleRunningChildBranch<T> {
    private SwitchHandler<? super T> handler;

    @Override
    protected void execute() {
        Task inlinedChild;
        if (this.runningChild == null) {
            int index = this.selectChild();
            if (index < 0) {
                this.runningIndex = -1;
                this.runningChild = null;
                this.setFailed(4);
                return;
            }
            this.runningIndex = index;
            this.runningChild = (Task)this.children.get(index);
        }
        if ((inlinedChild = this.inlineHelper.getInlinedChild()) != null) {
            inlinedChild.template_executeInlined(this.inlineHelper, this.runningChild);
        } else if (this.runningChild.isRunning()) {
            this.runningChild.template_execute(true);
        } else {
            this.template_startChild(this.runningChild, false);
        }
    }

    private int selectChild() {
        if (this.handler != null) {
            return this.handler.select(this);
        }
        for (int idx = 0; idx < this.children.size(); ++idx) {
            Task child = (Task)this.children.get(idx);
            if (!this.template_checkGuard(child.getGuard())) continue;
            return idx;
        }
        return -1;
    }

    @Override
    protected void onChildRunning(Task<T> child, boolean starting) {
        this.inlineHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        this.runningChild = null;
        this.inlineHelper.stopInline();
        this.setCompleted(child.getStatus(), true);
    }

    public SwitchHandler<? super T> getHandler() {
        return this.handler;
    }

    public void setHandler(SwitchHandler<? super T> handler) {
        this.handler = handler;
    }
}

