/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.fsm.ChangeStateArgs;
import cn.wjybxx.btree.fsm.StateMachineTask;
import java.util.ArrayDeque;

public class StackStateMachineTask<T>
extends StateMachineTask<T> {
    private static final int QUEUE_CAPACITY = 5;
    private int undoQueueCapacity = 5;
    private int redoQueueCapacity = 5;
    private final transient ArrayDeque<Task<T>> undoQueue = new ArrayDeque(5);
    private final transient ArrayDeque<Task<T>> redoQueue = new ArrayDeque(5);

    public final Task<T> peekUndoState() {
        return this.undoQueue.peekLast();
    }

    public final Task<T> peekRedoState() {
        return this.redoQueue.peekFirst();
    }

    public final void setUndoQueueCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        this.undoQueueCapacity = capacity;
        while (this.undoQueue.size() > capacity) {
            this.undoQueue.pollFirst();
        }
    }

    public final void setRedoQueueCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        this.redoQueueCapacity = capacity;
        while (this.redoQueue.size() > capacity) {
            this.redoQueue.pollLast();
        }
    }

    public final boolean addUndoState(Task<T> curState) {
        if (this.undoQueueCapacity < 1) {
            return false;
        }
        if (this.undoQueue.size() == this.undoQueueCapacity) {
            this.undoQueue.pollFirst();
        }
        this.undoQueue.addLast(curState);
        return true;
    }

    public final boolean addRedoState(Task<T> curState) {
        if (this.redoQueueCapacity < 1) {
            return false;
        }
        if (this.redoQueue.size() == this.redoQueueCapacity) {
            this.redoQueue.pollLast();
        }
        this.redoQueue.addFirst(curState);
        return true;
    }

    @Override
    public final boolean undoChangeState(ChangeStateArgs changeStateArgs) {
        if (!changeStateArgs.isUndo()) {
            throw new IllegalArgumentException();
        }
        Task<T> prevState = this.undoQueue.peekLast();
        if (prevState == null) {
            return false;
        }
        this.changeState(prevState, ChangeStateArgs.UNDO);
        return true;
    }

    @Override
    public final boolean redoChangeState(ChangeStateArgs changeStateArgs) {
        if (!changeStateArgs.isRedo()) {
            throw new IllegalArgumentException();
        }
        Task<T> nextState = this.redoQueue.peekFirst();
        if (nextState == null) {
            return false;
        }
        this.changeState(nextState, ChangeStateArgs.REDO);
        return true;
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.undoQueue.clear();
        this.redoQueue.clear();
    }

    @Override
    protected void exit() {
        this.undoQueue.clear();
        this.redoQueue.clear();
        super.exit();
    }

    @Override
    protected void beforeChangeState(Task<T> curState, Task<T> nextState) {
        if (nextState == null) {
            this.redoQueue.clear();
            this.addUndoState(curState);
            return;
        }
        ChangeStateArgs changeStateArgs = (ChangeStateArgs)nextState.getControlData();
        switch (changeStateArgs.cmd) {
            case 1: {
                this.undoQueue.pollLast();
                if (curState == null) break;
                this.addRedoState(curState);
                break;
            }
            case 2: {
                this.redoQueue.pollFirst();
                if (curState == null) break;
                this.addUndoState(curState);
                break;
            }
            default: {
                this.redoQueue.clear();
                if (curState == null) break;
                this.addUndoState(curState);
            }
        }
        super.beforeChangeState(curState, nextState);
    }

    public int getUndoQueueCapacity() {
        return this.undoQueueCapacity;
    }

    public int getRedoQueueCapacity() {
        return this.redoQueueCapacity;
    }
}

