/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.SingleRunningChildBranch;
import javax.annotation.Nullable;

public class TaskInlineHelper<T> {
    public static boolean enableInline = true;
    private static final int INVALID_REENTRY_ID = Integer.MIN_VALUE;
    private transient Task<T> inlinedChild = null;
    private transient int inlinedReentryId = Integer.MIN_VALUE;

    public final Task<T> getInlinedChild() {
        Task<T> r = this.inlinedChild;
        if (r == null) {
            return null;
        }
        if (r.getReentryId() == this.inlinedReentryId) {
            return r;
        }
        this.inlinedChild = null;
        this.inlinedReentryId = Integer.MIN_VALUE;
        return null;
    }

    public final void stopInline() {
        this.inlinedChild = null;
        this.inlinedReentryId = Integer.MIN_VALUE;
    }

    public final void inlineChild(Task<T> runningChild) {
        if (!runningChild.isRunning()) {
            throw new IllegalArgumentException("runningChild must running");
        }
        if (!enableInline) {
            this.inlinedChild = null;
            this.inlinedReentryId = Integer.MIN_VALUE;
            return;
        }
        Task cur = runningChild;
        while (cur.isInlinable()) {
            Decorator decorator;
            if (cur instanceof SingleRunningChildBranch) {
                SingleRunningChildBranch branch = cur;
                if ((cur = branch.getInlineHelper().getInlinedChild()) != null) break;
                cur = branch.getRunningChild();
                if (cur != null && !cur.isCompleted()) continue;
                cur = branch;
                break;
            }
            if (!(cur instanceof Decorator) || (cur = (decorator = (Decorator)cur).getInlineHelper().getInlinedChild()) != null) break;
            cur = decorator.getChild();
            if (cur != null && !cur.isCompleted()) continue;
            cur = decorator;
            break;
        }
        assert (cur.isRunning());
        if (cur == runningChild) {
            this.inlinedChild = null;
            this.inlinedReentryId = Integer.MIN_VALUE;
        } else {
            this.inlinedChild = cur;
            this.inlinedReentryId = cur.getReentryId();
        }
    }

    public final void onEvent(Object event, @Nullable Task<T> source) {
        Task<T> inlinedChild = this.getInlinedChild();
        if (inlinedChild != null) {
            inlinedChild.onEvent(event);
        } else if (source != null) {
            source.onEvent(event);
        }
    }
}

