/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public interface TreeLoader {
    @Nullable
    public Object tryLoadObject(String var1);

    default public Object loadObject(String nameOrGuid) {
        Object result = this.tryLoadObject(nameOrGuid);
        if (result == null) {
            throw new IllegalArgumentException("target object is absent, name: " + nameOrGuid);
        }
        return result;
    }

    default public List<Object> loadManyFromFile(String fileName, @Nullable Predicate<? super IEntry> filter) {
        return this.loadManyFromFile(fileName, filter, false);
    }

    public List<Object> loadManyFromFile(String var1, @Nullable Predicate<? super IEntry> var2, boolean var3);

    @Nullable
    default public <T> Task<T> tryLoadRootTask(String treeName) {
        Object result = this.tryLoadObject(treeName);
        if (result == null) {
            return null;
        }
        if (!(result instanceof Task)) {
            throw new IllegalArgumentException("target object is not a task, name: " + treeName);
        }
        Task task = (Task)result;
        return task;
    }

    default public <T> Task<T> loadRootTask(String treeName) {
        Object result = this.tryLoadObject(treeName);
        if (result == null) {
            throw new IllegalArgumentException("target tree is absent, name: " + treeName);
        }
        if (!(result instanceof Task)) {
            throw new IllegalArgumentException("target object is not a task, name: " + treeName);
        }
        Task task = (Task)result;
        return task;
    }

    default public <T> TaskEntry<T> loadTree(String treeName) {
        Task<T> rootTask = this.loadRootTask(treeName);
        return new TaskEntry<Object>(treeName, rootTask, null, null, this);
    }

    public static TreeLoader nullLoader() {
        return NullLoader.INSTANCE;
    }

    public static class NullLoader
    implements TreeLoader {
        static final NullLoader INSTANCE = new NullLoader();

        @Override
        public Object tryLoadObject(String nameOrGuid) {
            return null;
        }

        @Override
        public List<Object> loadManyFromFile(String fileName, @Nullable Predicate<? super IEntry> filter, boolean sharable) {
            return new ArrayList<Object>();
        }
    }

    public static interface IEntry {
        @Nullable
        public String getName();

        public String getGuid();

        public int getFlags();

        public int getType();

        public Object getRoot();
    }
}

