/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.ParallelBranch;
import cn.wjybxx.btree.branch.ParallelChildHelper;
import java.util.List;
import javax.annotation.Nonnull;

public class SimpleParallel<T>
extends ParallelBranch<T> {
    public SimpleParallel() {
    }

    public SimpleParallel(List<Task<T>> children) {
        super(children);
    }

    @Override
    protected void enter(int reentryId) {
        this.initChildHelpers();
    }

    @Override
    protected void execute() {
        List children = this.children;
        int reentryId = this.getReentryId();
        for (int idx = 0; idx < children.size(); ++idx) {
            Task child = (Task)children.get(idx);
            ParallelChildHelper childHelper = SimpleParallel.getChildHelper(child);
            Task inlinedChild = childHelper.getInlinedChild();
            if (inlinedChild != null) {
                inlinedChild.template_executeInlined(childHelper, child);
            } else if (child.isRunning()) {
                child.template_execute(true);
            } else {
                this.setChildCancelToken(child, childHelper.cancelToken);
                this.template_startChild(child, true);
            }
            if (!this.checkCancel(reentryId)) continue;
            return;
        }
    }

    @Override
    protected void onChildRunning(Task<T> child, boolean starting) {
        ParallelChildHelper<T> childHelper = SimpleParallel.getChildHelper(child);
        childHelper.inlineChild(child);
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        ParallelChildHelper<T> childHelper = SimpleParallel.getChildHelper(child);
        childHelper.stopInline();
        this.unsetChildCancelToken(child);
        Task mainTask = (Task)this.children.get(0);
        if (child == mainTask) {
            this.setCompleted(child.getStatus(), true);
        }
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        Task mainTask = (Task)this.children.get(0);
        ParallelChildHelper childHelper = SimpleParallel.getChildHelper(mainTask);
        Task inlinedChild = childHelper.getInlinedChild();
        if (inlinedChild != null) {
            inlinedChild.onEvent(event);
        } else {
            mainTask.onEvent(event);
        }
    }
}

